/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.commands.aef;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.xginko.aef.commands.AEFCommand;
import me.xginko.aef.commands.aef.subcommands.DisableSubCmd;
import me.xginko.aef.commands.aef.subcommands.ElytraSubCmd;
import me.xginko.aef.commands.aef.subcommands.GearedSubCmd;
import me.xginko.aef.commands.aef.subcommands.LagSubCmd;
import me.xginko.aef.commands.aef.subcommands.ReloadSubCmd;
import me.xginko.aef.commands.aef.subcommands.VersionSubCmd;
import me.xginko.aef.commands.aef.subcommands.bytesize.ByteSizeSubCmd;
import me.xginko.aef.utils.models.SubCommand;
import org.bukkit.command.CommandException;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;

public class AEFCmd
extends AEFCommand {
    private final Set<SubCommand> subCommands;
    private final List<String> tabCompletes;
    private final List<String> overview = (List)Stream.of("", "                 \u00a7b\u00a7lAnarchyExploitFixes Commands", "", "  \u00a7b/aef version \u00a78- \u00a7fShow the plugin version.", "  \u00a7b/aef reload \u00a78- \u00a7fReload the plugin.", "  \u00a7b/aef disable \u00a78- \u00a7fDisable the plugin.", "  \u00a7b/aef lag <millis> \u00a78- \u00a7fLag the server for testing.", "  \u00a7b/aef geared \u00a78- \u00a7fCount how many players are wearing gear.", "  \u00a7b/aef elytra \u00a78- \u00a7fCount how many players are flying elytra.", "  \u00a7b/aef datavalue \u00a78- \u00a7fShow the MaterialData value of an item.", "  \u00a7b/aef bytesize <mainhand/inventory> (player) (utf8/utf16)", "                \u00a78- \u00a7fGet the byte size of an item or inventory.", "").collect(Collectors.collectingAndThen(Collectors.toList(), ImmutableList::copyOf));

    public AEFCmd() {
        super("aef", "AnarchyExploitFixes admin commands", "/aef <reload, version, bytesize, disable, elytra, geared, lag>", Collections.emptyList());
        this.subCommands = ImmutableSet.of((Object)new ReloadSubCmd(), (Object)new VersionSubCmd(), (Object)new DisableSubCmd(), (Object)new ByteSizeSubCmd(), (Object)new LagSubCmd(), (Object)new ElytraSubCmd(), (Object[])new SubCommand[]{new GearedSubCmd()});
        this.tabCompletes = (List)this.subCommands.stream().map(SubCommand::label).sorted().collect(Collectors.collectingAndThen(Collectors.toList(), ImmutableList::copyOf));
    }

    @NotNull
    public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String alias, @NotNull String[] args) throws CommandException, IllegalArgumentException {
        if (args.length == 1) {
            return this.tabCompletes.stream().filter(cmd -> cmd.toLowerCase(Locale.ROOT).startsWith(args[0].toLowerCase(Locale.ROOT))).collect(Collectors.toList());
        }
        if (args.length > 1) {
            for (SubCommand subCommand : this.subCommands) {
                if (!args[0].equalsIgnoreCase(subCommand.label())) continue;
                return subCommand.tabComplete(sender, alias, args);
            }
        }
        return Collections.emptyList();
    }

    public boolean execute(@NotNull CommandSender sender, @NotNull String commandLabel, @NotNull String[] args) {
        if (args.length > 0) {
            for (SubCommand subCommand : this.subCommands) {
                if (!args[0].equalsIgnoreCase(subCommand.label())) continue;
                return subCommand.execute(sender, commandLabel, args);
            }
        }
        this.overview.forEach(arg_0 -> ((CommandSender)sender).sendMessage(arg_0));
        return true;
    }
}

