/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.commands.aef.subcommands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import me.xginko.aef.AnarchyExploitFixes;
import me.xginko.aef.utils.models.SubCommand;
import me.xginko.aef.utils.permissions.AEFPermission;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandException;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;
import org.jetbrains.annotations.NotNull;

public class GearedSubCmd
extends SubCommand {
    @Override
    @NotNull
    public String label() {
        return "geared";
    }

    @Override
    @NotNull
    public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String alias, @NotNull String[] args) throws CommandException, IllegalArgumentException {
        return Collections.emptyList();
    }

    @Override
    public boolean execute(@NotNull CommandSender sender, @NotNull String commandLabel, @NotNull String[] args) {
        if (!AnarchyExploitFixes.permissions().permissionValue((Permissible)sender, AEFPermission.CMD_AEF_GEARED.node()).toBoolean()) {
            sender.sendMessage(AnarchyExploitFixes.translation((CommandSender)sender).no_permission);
            return true;
        }
        ArrayList<String> geared = new ArrayList<String>();
        ArrayList<String> unGeared = new ArrayList<String>();
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (Arrays.stream(player.getInventory().getArmorContents()).anyMatch(Objects::nonNull)) {
                geared.add(player.getName());
                continue;
            }
            unGeared.add(player.getName());
        }
        sender.sendMessage("");
        sender.sendMessage(ChatColor.WHITE + " Geared players: " + ChatColor.AQUA + String.join((CharSequence)", ", geared) + ChatColor.WHITE + " (" + geared.size() + ")");
        sender.sendMessage(ChatColor.WHITE + " Ungeared players: " + ChatColor.AQUA + String.join((CharSequence)", ", unGeared) + ChatColor.WHITE + " (" + unGeared.size() + ")");
        sender.sendMessage(ChatColor.WHITE + " Total players: " + ChatColor.AQUA + (geared.size() + unGeared.size()));
        sender.sendMessage("");
        return true;
    }
}

