/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.commands.aef.subcommands;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import me.xginko.aef.AnarchyExploitFixes;
import me.xginko.aef.utils.models.SubCommand;
import me.xginko.aef.utils.permissions.AEFPermission;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandException;
import org.bukkit.command.CommandSender;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class LagSubCmd
extends SubCommand {
    private final List<String> tabCompletes = Arrays.asList("1000", "2500", "5000");

    @Override
    @NotNull
    public String label() {
        return "lag";
    }

    @Override
    @NotNull
    public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String alias, @NotNull String[] args) throws CommandException, IllegalArgumentException {
        if (args.length == 2 && AnarchyExploitFixes.permissions().permissionValue((Permissible)sender, AEFPermission.CMD_AEF_LAG.node()).toBoolean()) {
            return this.tabCompletes;
        }
        return Collections.emptyList();
    }

    @Override
    public boolean execute(@NotNull CommandSender sender, @NotNull String commandLabel, @NotNull String[] args) {
        if (!AnarchyExploitFixes.permissions().permissionValue((Permissible)sender, AEFPermission.CMD_AEF_LAG.node()).toBoolean()) {
            sender.sendMessage(AnarchyExploitFixes.translation((CommandSender)sender).no_permission);
            return true;
        }
        if (args.length != 2) {
            return true;
        }
        AnarchyExploitFixes plugin = AnarchyExploitFixes.getInstance();
        try {
            long millis = Long.parseLong(args[1]);
            sender.sendMessage("");
            sender.sendMessage(ChatColor.WHITE + " Lagging server for " + millis + " millis...");
            plugin.getServer().getScheduler().runTask((Plugin)plugin, () -> {
                try {
                    Thread.sleep(millis);
                    sender.sendMessage(ChatColor.AQUA + " Done.");
                    sender.sendMessage("");
                }
                catch (InterruptedException e) {
                    sender.sendMessage(ChatColor.RED + " Operation was interrupted! - " + e.getLocalizedMessage());
                    sender.sendMessage("");
                    AnarchyExploitFixes.logger().error("Lag command encountered an error!", e);
                }
            });
        }
        catch (NumberFormatException e) {
            sender.sendMessage(ChatColor.RED + " The value '" + args[1] + "' is not a valid long!");
        }
        return true;
    }
}

