/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.commands.aef.subcommands.bytesize;

import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import me.xginko.aef.AnarchyExploitFixes;
import me.xginko.aef.libs.caffeine.cache.Cache;
import me.xginko.aef.libs.caffeine.cache.Caffeine;
import me.xginko.aef.utils.ItemUtil;
import me.xginko.aef.utils.models.SubCommand;
import me.xginko.aef.utils.permissions.AEFPermission;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandException;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.permissions.Permissible;
import org.jetbrains.annotations.NotNull;

public class InventorySubCmd
extends SubCommand {
    private final List<String> utfList = Arrays.asList("UTF16", "UTF8");
    private final Cache<Boolean, List<String>> tabCompleteCache = Caffeine.newBuilder().expireAfterWrite(Duration.ofSeconds(10L)).build();

    @Override
    @NotNull
    public String label() {
        return "inventory";
    }

    @Override
    @NotNull
    public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String alias, @NotNull String[] args) throws CommandException, IllegalArgumentException {
        if (!AnarchyExploitFixes.permissions().permissionValue((Permissible)sender, AEFPermission.CMD_AEF_SIZE_INV.node()).toBoolean()) {
            return Collections.emptyList();
        }
        if (args.length == 3) {
            List playerList = this.tabCompleteCache.get(true, k -> Bukkit.getOnlinePlayers().stream().map(OfflinePlayer::getName).collect(Collectors.toList()));
            if (sender instanceof Player) {
                return "utf8".startsWith(args[2].toLowerCase()) || "utf16".startsWith(args[2].toLowerCase()) ? this.utfList : playerList;
            }
            return playerList;
        }
        if (args.length == 4 && !"utf8".startsWith(args[2].toLowerCase()) && !"utf16".startsWith(args[2].toLowerCase())) {
            return this.utfList;
        }
        return Collections.emptyList();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean execute(@NotNull CommandSender sender, @NotNull String commandLabel, @NotNull String[] args) {
        int byteSize;
        block11: {
            int byteSize2;
            block13: {
                block12: {
                    if (!AnarchyExploitFixes.permissions().permissionValue((Permissible)sender, AEFPermission.CMD_AEF_SIZE_INV.node()).toBoolean()) {
                        sender.sendMessage(AnarchyExploitFixes.translation((CommandSender)sender).no_permission);
                        return true;
                    }
                    if (args.length != 2) break block12;
                    if (!(sender instanceof Player)) {
                        sender.sendMessage(ChatColor.RED + "Please specify a player.");
                        return true;
                    }
                    byteSize = ItemUtil.getApproximateByteSize((Iterable<ItemStack>)((Player)sender).getInventory(), false);
                    break block11;
                }
                if (args.length != 3) break block13;
                if (args[2].equalsIgnoreCase("UTF16")) {
                    byteSize = ItemUtil.getApproximateByteSize((Iterable<ItemStack>)((Player)sender).getInventory(), true);
                    break block11;
                } else if (args[2].equalsIgnoreCase("UTF8")) {
                    byteSize = ItemUtil.getApproximateByteSize((Iterable<ItemStack>)((Player)sender).getInventory(), false);
                    break block11;
                } else {
                    Player target = Bukkit.getPlayer((String)args[2]);
                    if (target == null) {
                        sender.sendMessage(ChatColor.RED + "Player not found.");
                        return true;
                    }
                    int byteSize3 = ItemUtil.getApproximateByteSize((Iterable<ItemStack>)target.getInventory(), false);
                    sender.sendMessage(ChatColor.AQUA + target.getName() + "'s" + ChatColor.WHITE + " Inventory bytesize: " + ChatColor.AQUA + byteSize3);
                    return true;
                }
            }
            Player target = Bukkit.getPlayer((String)args[2]);
            if (target == null) {
                sender.sendMessage(ChatColor.RED + "Player not found.");
                return true;
            }
            if (args[3].equalsIgnoreCase("UTF16")) {
                byteSize2 = ItemUtil.getApproximateByteSize((Iterable<ItemStack>)target.getInventory(), true);
            } else {
                if (!args[3].equalsIgnoreCase("UTF8")) {
                    sender.sendMessage(ChatColor.RED + "Enter utf8 or utf16");
                    return true;
                }
                byteSize2 = ItemUtil.getApproximateByteSize((Iterable<ItemStack>)target.getInventory(), false);
            }
            sender.sendMessage(ChatColor.AQUA + target.getName() + "'s" + ChatColor.WHITE + " Inventory bytesize: " + ChatColor.AQUA + byteSize2);
            return true;
        }
        sender.sendMessage(ChatColor.WHITE + "Inventory bytesize: " + ChatColor.AQUA + byteSize);
        return true;
    }
}

