/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.config;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import me.xginko.aef.AnarchyExploitFixes;
import me.xginko.aef.libs.zaxxer.hikari.HikariConfig;
import me.xginko.aef.libs.zaxxer.hikari.HikariDataSource;
import me.xginko.aef.utils.models.Disableable;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.config.Configurator;

public class Datastore
implements Disableable {
    private static final String TABLE_PLAYERS = "players";
    private static final String COLUMN_PLAYER_UUID = "player_uuid";
    private static final String COLUMN_SHOW_CONN_MSGS = "show_connect_msgs";
    private static final String COLUMN_SHOW_FIRST_JOIN_MSGS = "show_first_join_msgs";
    private final HikariDataSource dataSource;

    public Datastore() {
        HikariConfig config = new HikariConfig();
        AnarchyExploitFixes plugin = AnarchyExploitFixes.getInstance();
        config.setJdbcUrl("jdbc:sqlite:" + plugin.getDataFolder().toPath() + "/data.db");
        config.setMaximumPoolSize(plugin.getServer().getMaxPlayers());
        this.dataSource = new HikariDataSource(config);
        this.createTables();
        this.configureSqlitePragmas();
    }

    @Override
    public void disable() {
        if (this.dataSource != null && !this.dataSource.isClosed()) {
            this.dataSource.close();
        }
    }

    private void createTables() {
        try (Connection connection = this.dataSource.getConnection();
             Statement statement = connection.createStatement();){
            statement.execute("CREATE TABLE IF NOT EXISTS `players` ( `player_uuid` TEXT NOT NULL PRIMARY KEY, `show_connect_msgs` INTEGER, `show_first_join_msgs` INTEGER);");
        }
        catch (SQLException e) {
            AnarchyExploitFixes.logger().trace("Error creating database tables!", e);
        }
    }

    private void configureSqlitePragmas() {
        try (Connection connection = this.dataSource.getConnection();
             Statement statement = connection.createStatement();){
            for (String pragma : Arrays.asList("PRAGMA journal_mode=WAL;", "PRAGMA wal_autocheckpoint=1000;", "PRAGMA busy_timeout=5000;", "PRAGMA synchronous=NORMAL;", "PRAGMA temp_store=MEMORY;")) {
                statement.execute(pragma);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public CompletableFuture<Boolean> getJoinLeaveEnabled(UUID uuid) {
        return CompletableFuture.supplyAsync(() -> {
            try (Connection connection = this.dataSource.getConnection();
                 PreparedStatement statement = connection.prepareStatement("SELECT `show_connect_msgs` FROM `players` WHERE `player_uuid` = ?;");){
                statement.setString(1, uuid.toString());
                try (ResultSet resultSet = statement.executeQuery();){
                    if (!resultSet.next()) return AnarchyExploitFixes.config().connectionMsgsAreOnByDefault;
                    boolean value = resultSet.getBoolean(COLUMN_SHOW_CONN_MSGS);
                    if (resultSet.wasNull()) return AnarchyExploitFixes.config().connectionMsgsAreOnByDefault;
                    Boolean bl = value;
                    return bl;
                }
            }
            catch (SQLException e) {
                AnarchyExploitFixes.logger().error("Error getting connection message enable state for player!", e);
            }
            return AnarchyExploitFixes.config().connectionMsgsAreOnByDefault;
        });
    }

    public CompletableFuture<Void> setJoinLeaveEnabled(UUID uuid, boolean enable) {
        return CompletableFuture.runAsync(() -> {
            try (Connection connection = this.dataSource.getConnection();
                 PreparedStatement statement = connection.prepareStatement("INSERT INTO `players` (`player_uuid`, `show_connect_msgs`) VALUES (?, ?) ON CONFLICT(`player_uuid`) DO UPDATE SET `show_connect_msgs` = excluded.`show_connect_msgs`;");){
                statement.setString(1, uuid.toString());
                statement.setBoolean(2, enable);
                statement.executeUpdate();
            }
            catch (SQLException e) {
                AnarchyExploitFixes.logger().error("Error setting connection message enable state for player!", e);
            }
        });
    }

    public CompletableFuture<Boolean> getFirstJoinEnabled(UUID uuid) {
        return CompletableFuture.supplyAsync(() -> {
            try (Connection connection = this.dataSource.getConnection();
                 PreparedStatement statement = connection.prepareStatement("SELECT `show_first_join_msgs` FROM `players` WHERE `player_uuid` = ?;");){
                statement.setString(1, uuid.toString());
                try (ResultSet resultSet = statement.executeQuery();){
                    if (!resultSet.next()) return AnarchyExploitFixes.config().firstJoinMsgsAreOnByDefault;
                    boolean value = resultSet.getBoolean(COLUMN_SHOW_FIRST_JOIN_MSGS);
                    if (!resultSet.wasNull()) {
                        Boolean bl = value;
                        return bl;
                    }
                    Boolean bl = value;
                    return bl;
                }
            }
            catch (SQLException e) {
                AnarchyExploitFixes.logger().error("Error getting first-join message enable state for player!", e);
            }
            return AnarchyExploitFixes.config().firstJoinMsgsAreOnByDefault;
        });
    }

    public CompletableFuture<Void> setFirstJoinEnabled(UUID uuid, boolean enable) {
        return CompletableFuture.runAsync(() -> {
            try (Connection connection = this.dataSource.getConnection();
                 PreparedStatement statement = connection.prepareStatement("INSERT INTO `players` (`player_uuid`, `show_first_join_msgs`) VALUES (?, ?) ON CONFLICT(`player_uuid`) DO UPDATE SET `show_first_join_msgs` = excluded.`show_first_join_msgs`;");){
                statement.setString(1, uuid.toString());
                statement.setBoolean(2, enable);
                statement.executeUpdate();
            }
            catch (SQLException e) {
                AnarchyExploitFixes.logger().error("Error setting first-join message enable state for player!", e);
            }
        });
    }

    static {
        String hikariShaded = AnarchyExploitFixes.class.getPackage().getName() + ".libs.zaxxer.hikari";
        Configurator.setLevel((String)(hikariShaded + ".pool.PoolBase"), (Level)Level.OFF);
        Configurator.setLevel((String)(hikariShaded + ".pool.HikariPool"), (Level)Level.OFF);
        Configurator.setLevel((String)(hikariShaded + ".HikariDataSource"), (Level)Level.OFF);
        Configurator.setLevel((String)(hikariShaded + ".HikariConfig"), (Level)Level.OFF);
        Configurator.setLevel((String)(hikariShaded + ".util.DriverDataSource"), (Level)Level.OFF);
    }
}

