/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.config;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import me.xginko.aef.AnarchyExploitFixes;
import me.xginko.aef.libs.configmaster.api.ConfigFile;
import me.xginko.aef.utils.LocaleUtil;
import org.bukkit.ChatColor;

public class Translation {
    private final ConfigFile translationFile;
    public final String no_permission;
    public final String invalid_syntax;
    public final String failed_argument_parse;
    public final String chat_CommandWhitelist_BadCommand;
    public final String misc_joinMessage;
    public final String misc_leaveMessage;
    public final String misc_MaskedKickMessage;
    public final String withers_SpawningDisabledInRadius;
    public final String misc_enabledConnectionMsgs;
    public final String misc_disabledConnectionMsgs;
    public final String misc_enabledFirstJoinMsgs;
    public final String misc_disabledFirstJoinMsgs;
    public final String elytra_disablePacketElytraFly;
    public final String elytra_global_YouAreFlyingIn;
    public final String elytra_global_New;
    public final String elytra_global_New_Color;
    public final String elytra_global_Old;
    public final String elytra_global_Old_Color;
    public final String elytra_global_Speed;
    public final String elytra_global_DisabledLowTPS;
    public final String elytra_global_TooFastLowTPS;
    public final String elytra_global_TooFastChunkInfo;
    public final String elytra_global_TooFast;
    public final String elytra_global_DisabledHere;
    public final String elytra_global_Chunks;
    public final String elytra_ceiling_DisabledHere;
    public final String elytra_ceiling_Chunks;
    public final String elytra_ceiling_YouAreFlyingIn;
    public final String elytra_ceiling_New;
    public final String elytra_ceiling_New_Color;
    public final String elytra_ceiling_Old;
    public final String elytra_ceiling_Old_Color;
    public final String elytra_ceiling_Speed;
    public final String elytra_ceiling_DisabledLowTPS;
    public final String elytra_ceiling_TooFastLowTPS;
    public final String elytra_ceiling_TooFastChunkInfo;
    public final String elytra_ceiling_TooFast;
    public final String elytra_spawn_DisabledHere;
    public final String elytra_spawn_YouAreFlyingIn;
    public final String elytra_spawn_New;
    public final String elytra_spawn_New_Color;
    public final String elytra_spawn_Old;
    public final String elytra_spawn_Old_Color;
    public final String elytra_spawn_Speed;
    public final String elytra_spawn_DisabledLowTPS;
    public final String elytra_spawn_TooFast;
    public final String elytra_spawn_TooFastChunkInfo;
    public final String elytra_spawn_Chunks;
    public final String lagpreventions_stopSpammingLevers;
    public final String mapspam_youCanOnlyCreateXMoreMaps;
    public final String mapspam_exceededLimit;
    public final String elytra_disable_timer;
    public final List<String> misc_firstJoinMessage;
    public final List<String> help_message;

    public Translation(Locale locale) throws Exception {
        AnarchyExploitFixes plugin = AnarchyExploitFixes.getInstance();
        String langFileName = LocaleUtil.languageTagForLocale(locale) + ".yml";
        File langYML = new File(plugin.getDataFolder() + "/lang", langFileName);
        if (!langYML.exists()) {
            plugin.saveResource("lang/" + langFileName, false);
        }
        this.translationFile = ConfigFile.loadConfig(langYML);
        this.no_permission = this.getTranslation("commands.no-permission", "&cYou don't have permission to use this command.");
        this.invalid_syntax = this.getTranslation("commands.invalid-syntax", "&cInvalid command syntax. Correct syntax: &7%syntax%");
        this.failed_argument_parse = this.getTranslation("commands.failed-argument-parse", "&cFailed to parse command arguments.");
        this.help_message = this.getListTranslation("commands.help-command", Arrays.asList("&3----------------------------------------------------", "&7/toggleconnectionmsgs &8- &7Turns off join messages", "&7/toggledeathmsgs &8- &7Turns off death messages", "&7/toggletells &8- &7Turns off private messages", "&7/togglechat &8- &7Turns off chat messages", "&7/ignore &8- &7Ignore certain players", "&7/seed &8- &7Shows the server seed", "&7/kill &8- &7Kills you", "&7/reply &8- &7Reply to messages", "&7/msg &8- &7Message other players", "&7/stats &8- &7Shows world statistics", "<&3----------------------------------------------------"));
        this.chat_CommandWhitelist_BadCommand = this.getTranslation("command-whitelist.bad-command", "&4Bad command. Type /help for a list of commands.");
        this.misc_joinMessage = this.getTranslation("join-leave-messages.join", "&7%player% joined the game.");
        this.misc_leaveMessage = this.getTranslation("join-leave-messages.leave", "&7%player% left the game.");
        this.misc_enabledConnectionMsgs = this.getTranslation("join-leave-messages.enabled-connection-msgs", "&7Enabled connection msgs");
        this.misc_disabledConnectionMsgs = this.getTranslation("join-leave-messages.disabled-connection-msgs", "&7Disabled connection msgs");
        this.misc_enabledFirstJoinMsgs = this.getTranslation("join-leave-messages.enabled-first-join-msgs", "&7Enabled first join msgs");
        this.misc_disabledFirstJoinMsgs = this.getTranslation("join-leave-messages.disabled-first-join-msgs", "&7Disabled first join msgs");
        this.misc_firstJoinMessage = this.getListTranslation("join-leave-messages.first-join", Collections.singletonList("&6%player% joined the game for the first time. They are %players_num% to join."));
        this.misc_MaskedKickMessage = this.getTranslation("kicks.masked-kick-message", "&6Disconnected");
        this.withers_SpawningDisabledInRadius = this.getTranslation("withers.disabled-at-spawn", "&4Wither spawning is disabled in a radius of %radius% blocks around spawn.");
        this.lagpreventions_stopSpammingLevers = this.getTranslation("redstone.stop-spamming-levers", "&cStop spamming levers.");
        this.mapspam_youCanOnlyCreateXMoreMaps = this.getTranslation("map-spam.you-can-only-create-x-more-maps", "&eDue to the limitations of the game, you will only be able to create %amount% more maps for the next %time%");
        this.mapspam_exceededLimit = this.getTranslation("map-spam.exceeded-map-creation-limit", "&cYou exceeded the map creation limit. Please wait %time%.");
        this.elytra_disablePacketElytraFly = this.getTranslation("elytra.disable-packet-elytrafly", "&cDisable Packet Elytra Fly.");
        this.elytra_disable_timer = this.getTranslation("elytra.disable-timer", "&cDisable Timer when traveling with an elytra.");
        this.elytra_global_DisabledHere = this.getTranslation("elytra.elytra-speed.global.disabled-here", "&cElytras are currently disabled.");
        this.elytra_global_YouAreFlyingIn = this.getTranslation("elytra.elytra-speed.global.you-are-flying-in", "&7You are flying in %neworold% &7%chunks%");
        this.elytra_global_New = this.getTranslation("elytra.elytra-speed.global.new", "new");
        this.elytra_global_New_Color = this.getTranslation("elytra.elytra-speed.global.color-newchunks", "&4");
        this.elytra_global_Old = this.getTranslation("elytra.elytra-speed.global.old", "old");
        this.elytra_global_Old_Color = this.getTranslation("elytra.elytra-speed.global.color-oldchunks", "&a");
        this.elytra_global_Speed = this.getTranslation("elytra.elytra-speed.global.speed", "&7Speed: %speed% / %maxspeed%");
        this.elytra_global_DisabledLowTPS = this.getTranslation("elytra.elytra-speed.global.disabled-low-tps", "&cElytras are currently disabled because the tps is lower than %tps%.");
        this.elytra_global_TooFastLowTPS = this.getTranslation("elytra.elytra-speed.global.going-too-fast-low-tps", "&cElytra speed is reduced during low tps. Turn down your settings.");
        this.elytra_global_TooFastChunkInfo = this.getTranslation("elytra.elytra-speed.global.going-too-fast-chunkinfo", "&cTurn down your settings. Elytra speed is restricted in %neworold% %chunks%");
        this.elytra_global_TooFast = this.getTranslation("elytra.elytra-speed.global.going-too-fast", "&cTurn down your settings. Elytra speed is restricted on this server.");
        this.elytra_global_Chunks = this.getTranslation("elytra.elytra-speed.global.chunks", "chunks");
        this.elytra_ceiling_DisabledHere = this.getTranslation("elytra.elytra-speed.nether-ceiling.disabled-here", "&cElytras are disabled on the nether ceiling.");
        this.elytra_ceiling_YouAreFlyingIn = this.getTranslation("elytra.elytra-speed.nether-ceiling.you-are-flying-in", "&7You are flying in %neworold% &7%chunks%");
        this.elytra_ceiling_New = this.getTranslation("elytra.elytra-speed.nether-ceiling.new", "new");
        this.elytra_ceiling_New_Color = this.getTranslation("elytra.elytra-speed.nether-ceiling.color-newchunks", "&4");
        this.elytra_ceiling_Old = this.getTranslation("elytra.elytra-speed.nether-ceiling.old", "old");
        this.elytra_ceiling_Old_Color = this.getTranslation("elytra.elytra-speed.nether-ceiling.color-oldchunks", "&a");
        this.elytra_ceiling_Speed = this.getTranslation("elytra.elytra-speed.nether-ceiling.speed", "&7Speed: %speed% / %maxspeed%");
        this.elytra_ceiling_DisabledLowTPS = this.getTranslation("elytra.elytra-speed.nether-ceiling.disabled-low-tps", "&cElytras are currently disabled because the tps is lower than %tps%.");
        this.elytra_ceiling_TooFastLowTPS = this.getTranslation("elytra.elytra-speed.nether-ceiling.going-too-fast-low-tps", "&cElytra speed is reduced during low tps. Turn down your settings.");
        this.elytra_ceiling_TooFastChunkInfo = this.getTranslation("elytra.elytra-speed.nether-ceiling.going-too-fast-chunkinfo", "&cTurn down your settings. Elytra speed is restricted in %neworold% %chunks%");
        this.elytra_ceiling_TooFast = this.getTranslation("elytra.elytra-speed.nether-ceiling.going-too-fast", "&cTurn down your settings. Elytra speed is restricted on the nether ceiling.");
        this.elytra_ceiling_Chunks = this.getTranslation("elytra.elytra-speed.nether-ceiling.chunks", "ceiling chunks");
        this.elytra_spawn_DisabledHere = this.getTranslation("elytra.elytra-speed.spawn.disabled-here", "&cElytras are disabled in a range of &6%range% &cblocks around spawn.");
        this.elytra_spawn_YouAreFlyingIn = this.getTranslation("elytra.elytra-speed.spawn.you-are-flying-in", "&7You are flying in %neworold% &7%chunks%");
        this.elytra_spawn_New = this.getTranslation("elytra.elytra-speed.spawn.new", "new");
        this.elytra_spawn_New_Color = this.getTranslation("elytra.elytra-speed.spawn.color-newchunks", "&4");
        this.elytra_spawn_Old = this.getTranslation("elytra.elytra-speed.spawn.old", "old");
        this.elytra_spawn_Old_Color = this.getTranslation("elytra.elytra-speed.spawn.color-oldchunks", "&a");
        this.elytra_spawn_Speed = this.getTranslation("elytra.elytra-speed.spawn.speed", "&7Speed: %speed% / %maxspeed%");
        this.elytra_spawn_DisabledLowTPS = this.getTranslation("elytra.elytra-speed.spawn.disabled-low-tps", "&cElytras are currently disabled because the tps is lower than %tps%.");
        this.elytra_spawn_TooFastChunkInfo = this.getTranslation("elytra.elytra-speed.spawn.going-too-fast-chunkinfo", "&cElytra speed is restricted in %neworold% %chunks% in a radius of %radius% blocks.");
        this.elytra_spawn_TooFast = this.getTranslation("elytra.elytra-speed.nether-ceiling.going-too-fast", "&cElytra speed is restricted in a radius of %radius% blocks around spawn.");
        this.elytra_spawn_Chunks = this.getTranslation("elytra.elytra-speed.spawn.chunks", "spawn chunks");
        try {
            this.translationFile.save();
        }
        catch (Exception e) {
            AnarchyExploitFixes.logger().trace("Failed to save language file: {}", (Object)langYML.getName(), (Object)e);
        }
    }

    private String getTranslation(String path, String defaultTranslation) {
        this.translationFile.addDefault(path, defaultTranslation);
        return ChatColor.translateAlternateColorCodes((char)'&', (String)this.translationFile.getString(path, defaultTranslation));
    }

    private String getTranslation(String path, String defaultTranslation, String comment) {
        this.translationFile.addDefault(path, defaultTranslation, comment);
        return ChatColor.translateAlternateColorCodes((char)'&', (String)this.translationFile.getString(path, defaultTranslation));
    }

    private List<String> getListTranslation(String path, List<String> defaultTranslation) {
        this.translationFile.addDefault(path, defaultTranslation);
        return this.translationFile.getStringList(path).stream().map(line -> ChatColor.translateAlternateColorCodes((char)'&', (String)line)).collect(Collectors.toList());
    }

    private List<String> getListTranslation(String path, List<String> defaultTranslation, String comment) {
        this.translationFile.addDefault(path, defaultTranslation, comment);
        return this.translationFile.getStringList(path).stream().map(line -> ChatColor.translateAlternateColorCodes((char)'&', (String)line)).collect(Collectors.toList());
    }
}

