/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.libs.configmaster.api;

import java.util.ArrayList;
import java.util.List;
import me.xginko.aef.libs.configmaster.api.ConfigFile;
import me.xginko.aef.libs.configmaster.api.comments.Comment;
import me.xginko.aef.libs.configmaster.api.comments.Section;

class CommentWriter {
    private final ConfigFile config;
    private List<String> currentLines;

    protected CommentWriter(ConfigFile config) {
        this.config = config;
        this.currentLines = new ArrayList<String>();
    }

    protected void writeComments(List<String> currentLines) {
        this.currentLines = currentLines;
        for (String path : this.config.getComments().keySet()) {
            this.writeComment(path, path.split("\\."), 0, 0);
        }
        for (Comment comment : this.config.getPendingComments()) {
            String[] rawComment;
            String str = comment.getComment();
            if (str.isEmpty()) {
                currentLines.add("");
                continue;
            }
            currentLines.add("");
            for (String commentPart : rawComment = str.split("\n")) {
                if (commentPart.isEmpty()) {
                    currentLines.add("");
                    continue;
                }
                if (comment instanceof Section) {
                    String section = commentPart.split(": ")[1];
                    StringBuilder length = new StringBuilder();
                    length.append("###");
                    for (int j = 0; j < section.length(); ++j) {
                        length.append("#");
                    }
                    length.append("###");
                    currentLines.add(length.toString());
                    currentLines.add("#  " + section + "  #");
                    currentLines.add(length.toString());
                    continue;
                }
                currentLines.add("# " + commentPart);
            }
        }
    }

    private void writeComment(String path, String[] divisions, int iteration, int startingLine) {
        StringBuilder indent = new StringBuilder();
        for (int j = 0; j < iteration; ++j) {
            indent.append("  ");
        }
        for (int i = startingLine; i < this.currentLines.size(); ++i) {
            String line = this.currentLines.get(i);
            if (!line.startsWith(indent.toString())) {
                return;
            }
            if (line.startsWith("#") || !line.startsWith(indent + divisions[iteration] + ":") && !line.startsWith(indent + "'" + divisions[iteration] + "':")) continue;
            if (++iteration != divisions.length) {
                this.writeComment(path, divisions, iteration, i + 1);
                continue;
            }
            int currentLine = i;
            List<Comment> comments = this.config.getComments().get(path);
            if (comments == null || comments.isEmpty()) continue;
            for (Comment comment : comments) {
                if (iteration == 1) {
                    this.currentLines.add(currentLine, "");
                    ++currentLine;
                }
                if (comment == null || comment.getComment().isEmpty()) {
                    this.currentLines.add(currentLine, "");
                    continue;
                }
                String commentStr = comment.getComment();
                String[] commentParts = commentStr.split("\n");
                if (comment instanceof Section) {
                    int max = 0;
                    for (String commentPart : commentParts) {
                        max = Math.max(commentPart.length(), max);
                    }
                    StringBuilder length = new StringBuilder();
                    length.append("###");
                    for (int j = 0; j < max; ++j) {
                        length.append("#");
                    }
                    length.append("###");
                    this.currentLines.add(currentLine, length.toString());
                    ++currentLine;
                    for (String commentPart : commentParts) {
                        this.currentLines.add(currentLine, "#  " + commentPart + "  #");
                        ++currentLine;
                    }
                    this.currentLines.add(currentLine, length.toString());
                    ++currentLine;
                    continue;
                }
                for (String commentPart : commentParts) {
                    this.currentLines.add(currentLine, indent + "# " + commentPart);
                    ++currentLine;
                }
            }
            break;
        }
    }

    protected List<String> getLines() {
        return this.currentLines;
    }
}

