/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.libs.xseries.profiles.lock;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import me.xginko.aef.libs.xseries.profiles.lock.KeyedLock;
import me.xginko.aef.libs.xseries.profiles.lock.KeyedLockMap;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
final class NulledKeyedLock<K, V>
implements KeyedLock<K, V> {
    protected final Lock lock = new ReentrantLock();
    private final KeyedLockMap<K> map;
    protected final K key;
    protected int pendingTasks;

    protected NulledKeyedLock(KeyedLockMap<K> map, K key) {
        this.map = map;
        this.key = key;
    }

    @Override
    public V getOrRetryValue() {
        return null;
    }

    @Override
    public void lock() {
        this.lock.lock();
    }

    protected boolean tryLock() {
        return this.lock.tryLock();
    }

    @Override
    public void unlock() {
        this.map.unlock(this);
    }

    @Override
    public void close() {
        this.unlock();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(key=" + this.key + ", pendingTasks=" + this.pendingTasks + ')';
    }
}

