/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.libs.zaxxer.hikari.pool;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.health.HealthCheckRegistry;
import io.micrometer.core.instrument.MeterRegistry;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLTransientConnectionException;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import me.xginko.aef.libs.zaxxer.hikari.HikariConfig;
import me.xginko.aef.libs.zaxxer.hikari.HikariPoolMXBean;
import me.xginko.aef.libs.zaxxer.hikari.metrics.MetricsTrackerFactory;
import me.xginko.aef.libs.zaxxer.hikari.metrics.PoolStats;
import me.xginko.aef.libs.zaxxer.hikari.metrics.dropwizard.CodahaleHealthChecker;
import me.xginko.aef.libs.zaxxer.hikari.metrics.dropwizard.CodahaleMetricsTrackerFactory;
import me.xginko.aef.libs.zaxxer.hikari.metrics.dropwizard.Dropwizard5MetricsTrackerFactory;
import me.xginko.aef.libs.zaxxer.hikari.metrics.micrometer.MicrometerMetricsTrackerFactory;
import me.xginko.aef.libs.zaxxer.hikari.pool.PoolBase;
import me.xginko.aef.libs.zaxxer.hikari.pool.PoolEntry;
import me.xginko.aef.libs.zaxxer.hikari.pool.ProxyConnection;
import me.xginko.aef.libs.zaxxer.hikari.pool.ProxyLeakTaskFactory;
import me.xginko.aef.libs.zaxxer.hikari.util.ClockSource;
import me.xginko.aef.libs.zaxxer.hikari.util.ConcurrentBag;
import me.xginko.aef.libs.zaxxer.hikari.util.SuspendResumeLock;
import me.xginko.aef.libs.zaxxer.hikari.util.UtilityElf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

@NestMembers(value={PoolInitializationException.class, KeepaliveTask.class, MaxLifetimeTask.class, HouseKeeper.class, PoolEntryCreator.class, 1.class})
public final class HikariPool
extends PoolBase
implements HikariPoolMXBean,
ConcurrentBag.IBagStateListener {
    private final Logger logger = LoggerFactory.getLogger(HikariPool.class);
    public static final int POOL_NORMAL = 0;
    public static final int POOL_SUSPENDED = 1;
    public static final int POOL_SHUTDOWN = 2;
    public volatile int poolState;
    private final long aliveBypassWindowMs = Long.getLong("me.xginko.aef.libs.zaxxer.hikari.aliveBypassWindowMs", TimeUnit.MILLISECONDS.toMillis(500L));
    private final long housekeepingPeriodMs = Long.getLong("me.xginko.aef.libs.zaxxer.hikari.housekeeping.periodMs", TimeUnit.SECONDS.toMillis(30L));
    private final long lifeTimeVarianceFactor = Math.min(40L, Math.max(2L, Long.getLong("me.xginko.aef.libs.zaxxer.hikari.lifeTimeVarianceFactor", 4L)));
    private final boolean isRequestBoundariesEnabled = Boolean.getBoolean("me.xginko.aef.libs.zaxxer.hikari.enableRequestBoundaries");
    private static final String EVICTED_CONNECTION_MESSAGE = "(connection was evicted)";
    private static final String DEAD_CONNECTION_MESSAGE = "(connection is dead)";
    private final PoolEntryCreator poolEntryCreator = new PoolEntryCreator();
    private final PoolEntryCreator postFillPoolEntryCreator = new PoolEntryCreator("After adding ");
    private final ThreadPoolExecutor addConnectionExecutor;
    private final ThreadPoolExecutor closeConnectionExecutor;
    private final ConcurrentBag<PoolEntry> connectionBag = new ConcurrentBag(this);
    private final ProxyLeakTaskFactory leakTaskFactory;
    private final SuspendResumeLock suspendResumeLock;
    private final ScheduledExecutorService houseKeepingExecutorService;
    private ScheduledFuture<?> houseKeeperTask;

    public HikariPool(HikariConfig config) {
        super(config);
        this.suspendResumeLock = config.isAllowPoolSuspension() ? new SuspendResumeLock() : SuspendResumeLock.FAUX_LOCK;
        this.houseKeepingExecutorService = this.initializeHouseKeepingExecutorService();
        this.checkFailFast();
        if (config.getMetricsTrackerFactory() != null) {
            this.setMetricsTrackerFactory(config.getMetricsTrackerFactory());
        } else {
            this.setMetricRegistry(config.getMetricRegistry());
        }
        this.setHealthCheckRegistry(config.getHealthCheckRegistry());
        this.handleMBeans(this, true);
        ThreadFactory threadFactory = config.getThreadFactory();
        int maxPoolSize = config.getMaximumPoolSize();
        this.addConnectionExecutor = UtilityElf.createThreadPoolExecutor(maxPoolSize, HikariPool.jvmdowngrader$concat$$init$$1(this.poolName), threadFactory, (RejectedExecutionHandler)new UtilityElf.CustomDiscardPolicy());
        this.closeConnectionExecutor = UtilityElf.createThreadPoolExecutor(maxPoolSize, HikariPool.jvmdowngrader$concat$$init$$2(this.poolName), threadFactory, (RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());
        this.leakTaskFactory = new ProxyLeakTaskFactory(config.getLeakDetectionThreshold(), this.houseKeepingExecutorService);
        this.houseKeeperTask = this.houseKeepingExecutorService.scheduleWithFixedDelay(new HouseKeeper(), 100L, this.housekeepingPeriodMs, TimeUnit.MILLISECONDS);
        if (Boolean.getBoolean("me.xginko.aef.libs.zaxxer.hikari.blockUntilFilled") && config.getInitializationFailTimeout() > 1L) {
            this.addConnectionExecutor.setMaximumPoolSize(Math.min(16, Runtime.getRuntime().availableProcessors()));
            this.addConnectionExecutor.setCorePoolSize(Math.min(16, Runtime.getRuntime().availableProcessors()));
            long startTime = ClockSource.currentTime();
            while (ClockSource.elapsedMillis(startTime) < config.getInitializationFailTimeout() && this.getTotalConnections() < config.getMinimumIdle()) {
                UtilityElf.quietlySleep(TimeUnit.MILLISECONDS.toMillis(100L));
            }
            this.addConnectionExecutor.setCorePoolSize(1);
            this.addConnectionExecutor.setMaximumPoolSize(1);
        }
    }

    public Connection getConnection() throws SQLException {
        return this.getConnection(this.connectionTimeout);
    }

    /*
     * Exception decompiling
     */
    public Connection getConnection(long hardTimeout) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[WHILELOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void shutdown() throws InterruptedException {
        block11: {
            this.poolState = 2;
            if (this.addConnectionExecutor != null) break block11;
            this.logPoolState("After  shutdown ");
            this.handleMBeans(this, false);
            this.metricsTracker.close();
            return;
        }
        try {
            this.logPoolState("Before shutdown ");
            if (this.houseKeeperTask != null) {
                this.houseKeeperTask.cancel(false);
                this.houseKeeperTask = null;
            }
            this.softEvictConnections();
            this.addConnectionExecutor.shutdown();
            if (!this.addConnectionExecutor.awaitTermination(this.getLoginTimeout(), TimeUnit.SECONDS)) {
                this.logger.warn("Timed-out waiting for add connection executor to shutdown");
            }
            this.destroyHouseKeepingExecutorService();
            this.connectionBag.close();
            ThreadPoolExecutor assassinExecutor = UtilityElf.createThreadPoolExecutor(this.config.getMaximumPoolSize(), HikariPool.jvmdowngrader$concat$shutdown$1(this.poolName), this.config.getThreadFactory(), (RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());
            try {
                long start = ClockSource.currentTime();
                do {
                    this.abortActiveConnections(assassinExecutor);
                    this.softEvictConnections();
                } while (this.getTotalConnections() > 0 && ClockSource.elapsedMillis(start) < TimeUnit.SECONDS.toMillis(10L));
            }
            finally {
                assassinExecutor.shutdown();
                if (!assassinExecutor.awaitTermination(10L, TimeUnit.SECONDS)) {
                    this.logger.warn("Timed-out waiting for connection assassin to shutdown");
                }
            }
            this.shutdownNetworkTimeoutExecutor();
            this.closeConnectionExecutor.shutdown();
            if (!this.closeConnectionExecutor.awaitTermination(10L, TimeUnit.SECONDS)) {
                this.logger.warn("Timed-out waiting for close connection executor to shutdown");
            }
        }
        catch (Throwable throwable) {
            this.logPoolState("After  shutdown ");
            this.handleMBeans(this, false);
            this.metricsTracker.close();
            throw throwable;
        }
        this.logPoolState("After  shutdown ");
        this.handleMBeans(this, false);
        this.metricsTracker.close();
    }

    public void evictConnection(Connection connection) {
        ProxyConnection proxyConnection = (ProxyConnection)connection;
        proxyConnection.cancelLeakTask();
        try {
            this.softEvictConnection(proxyConnection.getPoolEntry(), "(connection evicted by user)", !connection.isClosed());
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void setMetricRegistry(Object metricRegistry) {
        if (metricRegistry != null && UtilityElf.safeIsAssignableFrom(metricRegistry, "com.codahale.metrics.MetricRegistry")) {
            this.setMetricsTrackerFactory(new CodahaleMetricsTrackerFactory((MetricRegistry)metricRegistry));
        } else if (metricRegistry != null && UtilityElf.safeIsAssignableFrom(metricRegistry, "io.dropwizard.metrics5.MetricRegistry")) {
            this.setMetricsTrackerFactory(new Dropwizard5MetricsTrackerFactory((io.dropwizard.metrics5.MetricRegistry)metricRegistry));
        } else if (metricRegistry != null && UtilityElf.safeIsAssignableFrom(metricRegistry, "io.micrometer.core.instrument.MeterRegistry")) {
            this.setMetricsTrackerFactory(new MicrometerMetricsTrackerFactory((MeterRegistry)metricRegistry));
        } else {
            this.setMetricsTrackerFactory(null);
        }
    }

    public void setMetricsTrackerFactory(MetricsTrackerFactory metricsTrackerFactory) {
        this.metricsTracker = metricsTrackerFactory != null ? new PoolBase.MetricsTrackerDelegate(metricsTrackerFactory.create(this.config.getPoolName(), this.getPoolStats())) : new PoolBase.NopMetricsTrackerDelegate();
    }

    public void setHealthCheckRegistry(Object healthCheckRegistry) {
        if (healthCheckRegistry != null) {
            CodahaleHealthChecker.registerHealthChecks(this, this.config, (HealthCheckRegistry)healthCheckRegistry);
        }
    }

    @Override
    public void addBagItem(int waiting) {
        if (waiting > this.addConnectionExecutor.getQueue().size()) {
            this.addConnectionExecutor.submit(this.poolEntryCreator);
        }
    }

    @Override
    public int getActiveConnections() {
        return this.connectionBag.getCount(1);
    }

    @Override
    public int getIdleConnections() {
        return this.connectionBag.getCount(0);
    }

    @Override
    public int getTotalConnections() {
        return this.connectionBag.size();
    }

    @Override
    public int getThreadsAwaitingConnection() {
        return this.connectionBag.getWaitingThreadCount();
    }

    @Override
    public void softEvictConnections() {
        this.connectionBag.values().forEach(poolEntry -> this.softEvictConnection((PoolEntry)poolEntry, "(connection evicted)", false));
    }

    @Override
    public synchronized void suspendPool() {
        if (this.suspendResumeLock == SuspendResumeLock.FAUX_LOCK) {
            throw new IllegalStateException(HikariPool.jvmdowngrader$concat$suspendPool$1(this.poolName));
        }
        if (this.poolState != 1) {
            this.suspendResumeLock.suspend();
            this.poolState = 1;
        }
    }

    @Override
    public synchronized void resumePool() {
        if (this.poolState == 1) {
            this.poolState = 0;
            this.fillPool(false);
            this.suspendResumeLock.resume();
        }
    }

    void logPoolState(String ... prefix) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("{} - {}stats (total={}/{}, idle={}/{}, active={}, waiting={})", this.poolName, prefix.length > 0 ? prefix[0] : "", this.getTotalConnections(), this.config.getMaximumPoolSize(), this.getIdleConnections(), this.config.getMinimumIdle(), this.getActiveConnections(), this.getThreadsAwaitingConnection());
        }
    }

    @Override
    void recycle(PoolEntry poolEntry) {
        this.metricsTracker.recordConnectionUsage(poolEntry);
        if (poolEntry.isMarkedEvicted()) {
            this.closeConnection(poolEntry, EVICTED_CONNECTION_MESSAGE);
        } else {
            if (this.isRequestBoundariesEnabled) {
                try {
                    poolEntry.connection.endRequest();
                }
                catch (SQLException e) {
                    this.logger.warn("endRequest Failed for: {},({})", (Object)poolEntry.connection, (Object)e.getMessage());
                }
            }
            this.connectionBag.requite(poolEntry);
        }
    }

    void closeConnection(PoolEntry poolEntry, String closureReason) {
        if (this.connectionBag.remove(poolEntry)) {
            Connection connection = poolEntry.close();
            this.closeConnectionExecutor.execute(() -> {
                this.quietlyCloseConnection(connection, closureReason);
                if (this.poolState == 0) {
                    this.fillPool(false);
                }
            });
        }
    }

    int[] getPoolStateCounts() {
        return this.connectionBag.getStateCounts();
    }

    private PoolEntry createPoolEntry() {
        block6: {
            try {
                long keepaliveTime;
                PoolEntry poolEntry = this.newPoolEntry(this.getTotalConnections() == 0);
                long maxLifetime = this.config.getMaxLifetime();
                if (maxLifetime > 0L) {
                    long variance = maxLifetime > 10000L ? ThreadLocalRandom.current().nextLong(maxLifetime / this.lifeTimeVarianceFactor) : 0L;
                    long lifetime = maxLifetime - variance;
                    poolEntry.setFutureEol(this.houseKeepingExecutorService.schedule(new MaxLifetimeTask(poolEntry), lifetime, TimeUnit.MILLISECONDS));
                }
                if ((keepaliveTime = this.config.getKeepaliveTime()) > 0L) {
                    long variance = ThreadLocalRandom.current().nextLong(keepaliveTime / 5L);
                    long heartbeatTime = keepaliveTime - variance;
                    poolEntry.setKeepalive(this.houseKeepingExecutorService.scheduleWithFixedDelay(new KeepaliveTask(poolEntry), heartbeatTime, heartbeatTime, TimeUnit.MILLISECONDS));
                }
                return poolEntry;
            }
            catch (PoolBase.ConnectionSetupException e) {
                if (this.poolState == 0) {
                    this.logger.debug("{} - Error thrown while acquiring connection from data source", (Object)this.poolName, (Object)e.getCause());
                }
            }
            catch (Throwable e) {
                if (this.poolState != 0) break block6;
                this.logger.debug("{} - Cannot acquire connection from data source", (Object)this.poolName, (Object)e);
            }
        }
        return null;
    }

    private synchronized void fillPool(boolean isAfterAdd) {
        boolean shouldAdd;
        int idle = this.getIdleConnections();
        boolean bl = shouldAdd = this.getTotalConnections() < this.config.getMaximumPoolSize() && idle < this.config.getMinimumIdle();
        if (shouldAdd) {
            int countToAdd = this.config.getMinimumIdle() - idle;
            for (int i = 0; i < countToAdd; ++i) {
                this.addConnectionExecutor.submit(isAfterAdd ? this.postFillPoolEntryCreator : this.poolEntryCreator);
            }
        } else if (isAfterAdd) {
            this.logger.debug("{} - Fill pool skipped, pool has sufficient level or currently being filled.", (Object)this.poolName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void abortActiveConnections(ExecutorService assassinExecutor) {
        for (PoolEntry poolEntry : this.connectionBag.values(1)) {
            Connection connection = poolEntry.close();
            try {
                connection.abort(assassinExecutor);
            }
            catch (Throwable e) {
                this.quietlyCloseConnection(connection, "(connection aborted during shutdown)");
            }
            finally {
                this.connectionBag.remove(poolEntry);
            }
        }
    }

    private void checkFailFast() {
        long initializationFailTimeout = this.config.getInitializationFailTimeout();
        if (initializationFailTimeout < 0L) {
            return;
        }
        long startTime = ClockSource.currentTime();
        do {
            PoolEntry poolEntry;
            if ((poolEntry = this.createPoolEntry()) != null) {
                if (this.config.getMinimumIdle() > 0) {
                    this.connectionBag.add(poolEntry);
                    this.logger.info("{} - Added connection {}", (Object)this.poolName, (Object)poolEntry.connection);
                } else {
                    this.quietlyCloseConnection(poolEntry.close(), "(initialization check complete and minimumIdle is zero)");
                }
                return;
            }
            if (this.getLastConnectionFailure() instanceof PoolBase.ConnectionSetupException) {
                this.throwPoolInitializationException(this.getLastConnectionFailure().getCause());
            }
            UtilityElf.quietlySleep(TimeUnit.SECONDS.toMillis(1L));
        } while (ClockSource.elapsedMillis(startTime) < initializationFailTimeout);
        if (initializationFailTimeout > 0L) {
            this.throwPoolInitializationException(this.getLastConnectionFailure());
        }
    }

    private void throwPoolInitializationException(Throwable t2) {
        this.destroyHouseKeepingExecutorService();
        throw new PoolInitializationException(t2);
    }

    private boolean softEvictConnection(PoolEntry poolEntry, String reason, boolean owner) {
        poolEntry.markEvicted();
        if (owner || this.connectionBag.reserve(poolEntry)) {
            this.closeConnection(poolEntry, reason);
            return true;
        }
        return false;
    }

    private ScheduledExecutorService initializeHouseKeepingExecutorService() {
        if (this.config.getScheduledExecutor() == null) {
            ThreadFactory threadFactory = Optional.ofNullable(this.config.getThreadFactory()).orElseGet(() -> new UtilityElf.DefaultThreadFactory(HikariPool.jvmdowngrader$concat$lambda$initializeHouseKeepingExecutorService$2$1(this.poolName)));
            ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1, threadFactory, new ThreadPoolExecutor.DiscardPolicy());
            executor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
            executor.setRemoveOnCancelPolicy(true);
            return executor;
        }
        return this.config.getScheduledExecutor();
    }

    private void destroyHouseKeepingExecutorService() {
        if (this.config.getScheduledExecutor() == null) {
            this.houseKeepingExecutorService.shutdownNow();
        }
    }

    private PoolStats getPoolStats() {
        return new PoolStats(TimeUnit.SECONDS.toMillis(1L)){

            @Override
            protected void update() {
                this.pendingThreads = HikariPool.this.getThreadsAwaitingConnection();
                this.idleConnections = HikariPool.this.getIdleConnections();
                this.totalConnections = HikariPool.this.getTotalConnections();
                this.activeConnections = HikariPool.this.getActiveConnections();
                this.maxConnections = HikariPool.this.config.getMaximumPoolSize();
                this.minConnections = HikariPool.this.config.getMinimumIdle();
            }
        };
    }

    private SQLException createTimeoutException(long startTime) {
        this.logPoolState("Timeout failure ");
        this.metricsTracker.recordConnectionTimeout();
        String sqlState = null;
        int errorCode = 0;
        Throwable originalException = this.getLastConnectionFailure();
        if (originalException instanceof SQLException) {
            sqlState = ((SQLException)originalException).getSQLState();
            errorCode = ((SQLException)originalException).getErrorCode();
        }
        SQLTransientConnectionException connectionException = new SQLTransientConnectionException(HikariPool.jvmdowngrader$concat$createTimeoutException$1(this.poolName, ClockSource.elapsedMillis(startTime), this.getTotalConnections(), this.getActiveConnections(), this.getIdleConnections(), this.getThreadsAwaitingConnection()), sqlState, errorCode, originalException);
        if (originalException instanceof SQLException) {
            connectionException.setNextException((SQLException)originalException);
        }
        return connectionException;
    }

    public /* synthetic */ PoolEntry jvmdowngrader$nest$me_xginko_aef_libs_zaxxer_hikari_pool_HikariPool$createPoolEntry() {
        return this.createPoolEntry();
    }

    public /* synthetic */ ConcurrentBag jvmdowngrader$nest$me_xginko_aef_libs_zaxxer_hikari_pool_HikariPool$get$connectionBag() {
        return this.connectionBag;
    }

    public /* synthetic */ void jvmdowngrader$nest$me_xginko_aef_libs_zaxxer_hikari_pool_HikariPool$set$connectionBag(ConcurrentBag concurrentBag) {
        this.connectionBag = concurrentBag;
    }

    public /* synthetic */ ProxyLeakTaskFactory jvmdowngrader$nest$me_xginko_aef_libs_zaxxer_hikari_pool_HikariPool$get$leakTaskFactory() {
        return this.leakTaskFactory;
    }

    public /* synthetic */ void jvmdowngrader$nest$me_xginko_aef_libs_zaxxer_hikari_pool_HikariPool$set$leakTaskFactory(ProxyLeakTaskFactory proxyLeakTaskFactory) {
        this.leakTaskFactory = proxyLeakTaskFactory;
    }

    public /* synthetic */ Logger jvmdowngrader$nest$me_xginko_aef_libs_zaxxer_hikari_pool_HikariPool$get$logger() {
        return this.logger;
    }

    public /* synthetic */ void jvmdowngrader$nest$me_xginko_aef_libs_zaxxer_hikari_pool_HikariPool$set$logger(Logger logger) {
        this.logger = logger;
    }

    public /* synthetic */ long jvmdowngrader$nest$me_xginko_aef_libs_zaxxer_hikari_pool_HikariPool$get$housekeepingPeriodMs() {
        return this.housekeepingPeriodMs;
    }

    public /* synthetic */ void jvmdowngrader$nest$me_xginko_aef_libs_zaxxer_hikari_pool_HikariPool$set$housekeepingPeriodMs(long l) {
        this.housekeepingPeriodMs = l;
    }

    public /* synthetic */ boolean jvmdowngrader$nest$me_xginko_aef_libs_zaxxer_hikari_pool_HikariPool$softEvictConnection(PoolEntry poolEntry, String string, boolean bl) {
        return this.softEvictConnection(poolEntry, string, bl);
    }

    public /* synthetic */ void jvmdowngrader$nest$me_xginko_aef_libs_zaxxer_hikari_pool_HikariPool$fillPool(boolean bl) {
        this.fillPool(bl);
    }

    private static /* synthetic */ String jvmdowngrader$concat$$init$$1(String string) {
        return string + ":connection-adder";
    }

    private static /* synthetic */ String jvmdowngrader$concat$$init$$2(String string) {
        return string + ":connection-closer";
    }

    private static /* synthetic */ String jvmdowngrader$concat$getConnection$1(String string) {
        return string + " - Interrupted during connection acquisition";
    }

    private static /* synthetic */ String jvmdowngrader$concat$shutdown$1(String string) {
        return string + ":connection-assassinator";
    }

    private static /* synthetic */ String jvmdowngrader$concat$suspendPool$1(String string) {
        return string + " - is not suspendable";
    }

    private static /* synthetic */ String jvmdowngrader$concat$createTimeoutException$1(String string, long l, int n, int n2, int n3, int n4) {
        return string + " - Connection is not available, request timed out after " + l + "ms (total=" + n + ", active=" + n2 + ", idle=" + n3 + ", waiting=" + n4 + ")";
    }

    private static /* synthetic */ String jvmdowngrader$concat$lambda$initializeHouseKeepingExecutorService$2$1(String string) {
        return string + ":housekeeper";
    }

    @NestHost(value=HikariPool.class)
    public static class PoolInitializationException
    extends RuntimeException {
        private static final long serialVersionUID = 929872118275916520L;

        public PoolInitializationException(Throwable t2) {
            super(PoolInitializationException.jvmdowngrader$concat$$init$$1(t2.getMessage()), t2);
        }

        private static /* synthetic */ String jvmdowngrader$concat$$init$$1(String string) {
            return "Failed to initialize pool: " + string;
        }
    }

    @NestHost(value=HikariPool.class)
    private final class KeepaliveTask
    implements Runnable {
        private final PoolEntry poolEntry;

        KeepaliveTask(PoolEntry poolEntry) {
            this.poolEntry = poolEntry;
        }

        @Override
        public void run() {
            if (HikariPool.this.jvmdowngrader$nest$me_xginko_aef_libs_zaxxer_hikari_pool_HikariPool$get$connectionBag().reserve(this.poolEntry)) {
                if (HikariPool.this.isConnectionDead(this.poolEntry.connection)) {
                    HikariPool.this.jvmdowngrader$nest$me_xginko_aef_libs_zaxxer_hikari_pool_HikariPool$softEvictConnection(this.poolEntry, HikariPool.DEAD_CONNECTION_MESSAGE, true);
                    HikariPool.this.addBagItem(HikariPool.this.jvmdowngrader$nest$me_xginko_aef_libs_zaxxer_hikari_pool_HikariPool$get$connectionBag().getWaitingThreadCount());
                } else {
                    HikariPool.this.jvmdowngrader$nest$me_xginko_aef_libs_zaxxer_hikari_pool_HikariPool$get$connectionBag().unreserve(this.poolEntry);
                    HikariPool.this.jvmdowngrader$nest$me_xginko_aef_libs_zaxxer_hikari_pool_HikariPool$get$logger().debug("{} - keepalive: connection {} is alive", (Object)HikariPool.this.poolName, (Object)this.poolEntry.connection);
                }
            }
        }
    }

    @NestHost(value=HikariPool.class)
    private final class MaxLifetimeTask
    implements Runnable {
        private final PoolEntry poolEntry;

        MaxLifetimeTask(PoolEntry poolEntry) {
            this.poolEntry = poolEntry;
        }

        @Override
        public void run() {
            if (HikariPool.this.jvmdowngrader$nest$me_xginko_aef_libs_zaxxer_hikari_pool_HikariPool$softEvictConnection(this.poolEntry, "(connection has passed maxLifetime)", false)) {
                HikariPool.this.addBagItem(HikariPool.this.jvmdowngrader$nest$me_xginko_aef_libs_zaxxer_hikari_pool_HikariPool$get$connectionBag().getWaitingThreadCount());
            }
        }
    }

    @NestHost(value=HikariPool.class)
    private final class HouseKeeper
    implements Runnable {
        private volatile long previous;
        private final AtomicReferenceFieldUpdater<PoolBase, String> catalogUpdater;

        HouseKeeper() {
            this.previous = ClockSource.plusMillis(ClockSource.currentTime(), -HikariPool.this.jvmdowngrader$nest$me_xginko_aef_libs_zaxxer_hikari_pool_HikariPool$get$housekeepingPeriodMs());
            this.catalogUpdater = AtomicReferenceFieldUpdater.newUpdater(PoolBase.class, String.class, "catalog");
        }

        @Override
        public void run() {
            try {
                HikariPool.this.connectionTimeout = HikariPool.this.config.getConnectionTimeout();
                HikariPool.this.validationTimeout = HikariPool.this.config.getValidationTimeout();
                HikariPool.this.jvmdowngrader$nest$me_xginko_aef_libs_zaxxer_hikari_pool_HikariPool$get$leakTaskFactory().updateLeakDetectionThreshold(HikariPool.this.config.getLeakDetectionThreshold());
                if (HikariPool.this.config.getCatalog() != null && !HikariPool.this.config.getCatalog().equals(HikariPool.this.catalog)) {
                    this.catalogUpdater.set(HikariPool.this, HikariPool.this.config.getCatalog());
                }
                long idleTimeout = HikariPool.this.config.getIdleTimeout();
                long now = ClockSource.currentTime();
                if (ClockSource.plusMillis(now, 128L) < ClockSource.plusMillis(this.previous, HikariPool.this.jvmdowngrader$nest$me_xginko_aef_libs_zaxxer_hikari_pool_HikariPool$get$housekeepingPeriodMs())) {
                    HikariPool.this.jvmdowngrader$nest$me_xginko_aef_libs_zaxxer_hikari_pool_HikariPool$get$logger().warn("{} - Retrograde clock change detected (housekeeper delta={}), soft-evicting connections from pool.", (Object)HikariPool.this.poolName, (Object)ClockSource.elapsedDisplayString(this.previous, now));
                    this.previous = now;
                    HikariPool.this.softEvictConnections();
                    return;
                }
                if (now > ClockSource.plusMillis(this.previous, 3L * HikariPool.this.jvmdowngrader$nest$me_xginko_aef_libs_zaxxer_hikari_pool_HikariPool$get$housekeepingPeriodMs() / 2L)) {
                    HikariPool.this.jvmdowngrader$nest$me_xginko_aef_libs_zaxxer_hikari_pool_HikariPool$get$logger().warn("{} - Thread starvation or clock leap detected (housekeeper delta={}).", (Object)HikariPool.this.poolName, (Object)ClockSource.elapsedDisplayString(this.previous, now));
                }
                this.previous = now;
                if (idleTimeout > 0L && HikariPool.this.config.getMinimumIdle() < HikariPool.this.config.getMaximumPoolSize()) {
                    HikariPool.this.logPoolState("Before cleanup ");
                    List notInUse = HikariPool.this.jvmdowngrader$nest$me_xginko_aef_libs_zaxxer_hikari_pool_HikariPool$get$connectionBag().values(0);
                    int maxToRemove = notInUse.size() - HikariPool.this.config.getMinimumIdle();
                    for (PoolEntry entry : notInUse) {
                        if (maxToRemove <= 0 || ClockSource.elapsedMillis(entry.lastAccessed, now) <= idleTimeout || !HikariPool.this.jvmdowngrader$nest$me_xginko_aef_libs_zaxxer_hikari_pool_HikariPool$get$connectionBag().reserve(entry)) continue;
                        HikariPool.this.closeConnection(entry, "(connection has passed idleTimeout)");
                        --maxToRemove;
                    }
                    HikariPool.this.logPoolState("After  cleanup ");
                } else {
                    HikariPool.this.logPoolState("Pool ");
                }
                HikariPool.this.jvmdowngrader$nest$me_xginko_aef_libs_zaxxer_hikari_pool_HikariPool$fillPool(true);
            }
            catch (Exception e) {
                HikariPool.this.jvmdowngrader$nest$me_xginko_aef_libs_zaxxer_hikari_pool_HikariPool$get$logger().error("Unexpected exception in housekeeping task", e);
            }
        }
    }

    @NestHost(value=HikariPool.class)
    private final class PoolEntryCreator
    implements Callable<Boolean> {
        private final String loggingPrefix;

        PoolEntryCreator() {
            this(null);
        }

        PoolEntryCreator(String loggingPrefix) {
            this.loggingPrefix = loggingPrefix;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean call() {
            block10: {
                boolean added;
                block9: {
                    long backoffMs = 10L;
                    added = false;
                    try {
                        while (this.shouldContinueCreating()) {
                            PoolEntry poolEntry = HikariPool.this.jvmdowngrader$nest$me_xginko_aef_libs_zaxxer_hikari_pool_HikariPool$createPoolEntry();
                            if (poolEntry != null) {
                                added = true;
                                HikariPool.this.jvmdowngrader$nest$me_xginko_aef_libs_zaxxer_hikari_pool_HikariPool$get$connectionBag().add(poolEntry);
                                HikariPool.this.jvmdowngrader$nest$me_xginko_aef_libs_zaxxer_hikari_pool_HikariPool$get$logger().debug("{} - Added connection {}", (Object)HikariPool.this.poolName, (Object)poolEntry.connection);
                                UtilityElf.quietlySleep(30L);
                                break;
                            }
                            if (this.loggingPrefix != null && backoffMs % 50L == 0L) {
                                HikariPool.this.jvmdowngrader$nest$me_xginko_aef_libs_zaxxer_hikari_pool_HikariPool$get$logger().debug("{} - Connection add failed, sleeping with backoff: {}ms", (Object)HikariPool.this.poolName, (Object)backoffMs);
                            }
                            UtilityElf.quietlySleep(backoffMs);
                            backoffMs = Math.min(TimeUnit.SECONDS.toMillis(5L), backoffMs * 2L);
                        }
                        if (!added || this.loggingPrefix == null) break block9;
                    }
                    catch (Throwable throwable) {
                        if (added && this.loggingPrefix != null) {
                            HikariPool.this.logPoolState(this.loggingPrefix);
                        } else if (!added) {
                            HikariPool.this.logPoolState("Connection not added, ");
                        }
                        throw throwable;
                    }
                    HikariPool.this.logPoolState(this.loggingPrefix);
                    break block10;
                }
                if (!added) {
                    HikariPool.this.logPoolState("Connection not added, ");
                }
            }
            return Boolean.FALSE;
        }

        private synchronized boolean shouldContinueCreating() {
            return HikariPool.this.poolState == 0 && HikariPool.this.getTotalConnections() < HikariPool.this.config.getMaximumPoolSize() && (HikariPool.this.getIdleConnections() < HikariPool.this.config.getMinimumIdle() || HikariPool.this.jvmdowngrader$nest$me_xginko_aef_libs_zaxxer_hikari_pool_HikariPool$get$connectionBag().getWaitingThreadCount() > HikariPool.this.getIdleConnections());
        }
    }
}

