/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.libs.zaxxer.hikari.util;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Array;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.LoaderClassPath;
import javassist.Modifier;
import javassist.NotFoundException;
import me.xginko.aef.libs.zaxxer.hikari.pool.ProxyCallableStatement;
import me.xginko.aef.libs.zaxxer.hikari.pool.ProxyConnection;
import me.xginko.aef.libs.zaxxer.hikari.pool.ProxyDatabaseMetaData;
import me.xginko.aef.libs.zaxxer.hikari.pool.ProxyPreparedStatement;
import me.xginko.aef.libs.zaxxer.hikari.pool.ProxyResultSet;
import me.xginko.aef.libs.zaxxer.hikari.pool.ProxyStatement;

public final class JavassistProxyFactory {
    private static ClassPool classPool;
    private static String genDirectory;

    public static void main(String ... args) throws Exception {
        classPool = new ClassPool();
        classPool.importPackage("java.sql");
        classPool.appendClassPath(new LoaderClassPath(JavassistProxyFactory.class.getClassLoader()));
        if (args.length > 0) {
            String parentDir = args[0];
            if (!parentDir.endsWith(File.separator)) {
                parentDir = JavassistProxyFactory.jvmdowngrader$concat$main$1(parentDir, File.separator);
            }
            genDirectory = JavassistProxyFactory.jvmdowngrader$concat$main$1(parentDir, genDirectory);
        }
        System.out.println(JavassistProxyFactory.jvmdowngrader$concat$main$1(genDirectory));
        String methodBody = "{ try { return delegate.method($$); } catch (SQLException e) { throw checkException(e); } }";
        JavassistProxyFactory.generateProxyClass(Connection.class, ProxyConnection.class.getName(), methodBody);
        JavassistProxyFactory.generateProxyClass(Statement.class, ProxyStatement.class.getName(), methodBody);
        JavassistProxyFactory.generateProxyClass(ResultSet.class, ProxyResultSet.class.getName(), methodBody);
        JavassistProxyFactory.generateProxyClass(DatabaseMetaData.class, ProxyDatabaseMetaData.class.getName(), methodBody);
        methodBody = "{ try { return ((cast) delegate).method($$); } catch (SQLException e) { throw checkException(e); } }";
        JavassistProxyFactory.generateProxyClass(PreparedStatement.class, ProxyPreparedStatement.class.getName(), methodBody);
        JavassistProxyFactory.generateProxyClass(CallableStatement.class, ProxyCallableStatement.class.getName(), methodBody);
        JavassistProxyFactory.modifyProxyFactory();
    }

    private static void modifyProxyFactory() throws NotFoundException, CannotCompileException, IOException {
        System.out.println("Generating method bodies for com.zaxxer.hikari.proxy.ProxyFactory");
        String packageName = ProxyConnection.class.getPackage().getName();
        CtClass proxyCt = classPool.getCtClass("me.xginko.aef.libs.zaxxer.hikari.pool.ProxyFactory");
        block16: for (CtMethod method : proxyCt.getMethods()) {
            switch (method.getName()) {
                case "getProxyConnection": {
                    method.setBody(JavassistProxyFactory.jvmdowngrader$concat$modifyProxyFactory$1(packageName));
                    continue block16;
                }
                case "getProxyStatement": {
                    method.setBody(JavassistProxyFactory.jvmdowngrader$concat$modifyProxyFactory$2(packageName));
                    continue block16;
                }
                case "getProxyPreparedStatement": {
                    method.setBody(JavassistProxyFactory.jvmdowngrader$concat$modifyProxyFactory$3(packageName));
                    continue block16;
                }
                case "getProxyCallableStatement": {
                    method.setBody(JavassistProxyFactory.jvmdowngrader$concat$modifyProxyFactory$4(packageName));
                    continue block16;
                }
                case "getProxyResultSet": {
                    method.setBody(JavassistProxyFactory.jvmdowngrader$concat$modifyProxyFactory$5(packageName));
                    continue block16;
                }
                case "getProxyDatabaseMetaData": {
                    method.setBody(JavassistProxyFactory.jvmdowngrader$concat$modifyProxyFactory$6(packageName));
                    continue block16;
                }
            }
        }
        proxyCt.writeFile(genDirectory);
    }

    private static <T> void generateProxyClass(Class<T> primaryInterface, String superClassName, String methodBody) throws Exception {
        String newClassName = superClassName.replaceAll("(.+)\\.(\\w+)", "$1.Hikari$2");
        CtClass superCt = classPool.getCtClass(superClassName);
        CtClass targetCt = classPool.makeClass(newClassName, superCt);
        targetCt.setModifiers(Modifier.setPublic(16));
        System.out.println(JavassistProxyFactory.jvmdowngrader$concat$generateProxyClass$1(newClassName));
        HashSet<String> superSigs = new HashSet<String>();
        for (CtMethod method : superCt.getMethods()) {
            if ((method.getModifiers() & 0x10) != 16) continue;
            superSigs.add(JavassistProxyFactory.jvmdowngrader$concat$main$1(method.getName(), method.getSignature()));
        }
        HashSet<String> methods = new HashSet<String>();
        for (Class<?> intf : JavassistProxyFactory.getAllInterfaces(primaryInterface)) {
            CtClass intfCt = classPool.getCtClass(intf.getName());
            targetCt.addInterface(intfCt);
            for (CtMethod intfMethod : intfCt.getDeclaredMethods()) {
                String signature = JavassistProxyFactory.jvmdowngrader$concat$main$1(intfMethod.getName(), intfMethod.getSignature());
                if (superSigs.contains(signature) || methods.contains(signature)) continue;
                methods.add(signature);
                CtMethod method = CtNewMethod.copy(intfMethod, targetCt, null);
                String modifiedBody = methodBody;
                CtMethod superMethod = superCt.getMethod(intfMethod.getName(), intfMethod.getSignature());
                if ((superMethod.getModifiers() & 0x400) != 1024 && !JavassistProxyFactory.isDefaultMethod(intf, intfMethod)) {
                    modifiedBody = modifiedBody.replace("((cast) ", "");
                    modifiedBody = modifiedBody.replace("delegate", "super");
                    modifiedBody = modifiedBody.replace("super)", "super");
                }
                modifiedBody = modifiedBody.replace("cast", primaryInterface.getName());
                modifiedBody = JavassistProxyFactory.isThrowsSqlException(intfMethod) ? modifiedBody.replace("method", method.getName()) : "{ return ((cast) delegate).method($$); }".replace("method", method.getName()).replace("cast", primaryInterface.getName());
                if (method.getReturnType() == CtClass.voidType) {
                    modifiedBody = modifiedBody.replace("return", "");
                }
                method.setBody(modifiedBody);
                targetCt.addMethod(method);
            }
        }
        targetCt.getClassFile().setMajorVersion(52);
        targetCt.writeFile(genDirectory);
    }

    private static boolean isThrowsSqlException(CtMethod method) {
        try {
            for (CtClass clazz : method.getExceptionTypes()) {
                if (!clazz.getSimpleName().equals("SQLException")) continue;
                return true;
            }
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        return false;
    }

    private static boolean isDefaultMethod(Class<?> intf, CtMethod intfMethod) throws Exception {
        ArrayList paramTypes = new ArrayList();
        for (CtClass pt : intfMethod.getParameterTypes()) {
            paramTypes.add(JavassistProxyFactory.toJavaClass(pt));
        }
        return intf.getDeclaredMethod(intfMethod.getName(), paramTypes.toArray(new Class[0])).toString().contains("default ");
    }

    private static Set<Class<?>> getAllInterfaces(Class<?> clazz) {
        LinkedHashSet interfaces = new LinkedHashSet();
        for (Class<?> intf : clazz.getInterfaces()) {
            if (intf.getInterfaces().length > 0) {
                interfaces.addAll(JavassistProxyFactory.getAllInterfaces(intf));
            }
            interfaces.add(intf);
        }
        if (clazz.getSuperclass() != null) {
            interfaces.addAll(JavassistProxyFactory.getAllInterfaces(clazz.getSuperclass()));
        }
        if (clazz.isInterface()) {
            interfaces.add(clazz);
        }
        return interfaces;
    }

    private static Class<?> toJavaClass(CtClass cls) throws Exception {
        if (cls.getName().endsWith("[]")) {
            return Array.newInstance(JavassistProxyFactory.toJavaClass(cls.getName().replace("[]", "")), 0).getClass();
        }
        return JavassistProxyFactory.toJavaClass(cls.getName());
    }

    private static Class<?> toJavaClass(String cn) throws Exception {
        switch (cn) {
            case "int": {
                return Integer.TYPE;
            }
            case "long": {
                return Long.TYPE;
            }
            case "short": {
                return Short.TYPE;
            }
            case "byte": {
                return Byte.TYPE;
            }
            case "float": {
                return Float.TYPE;
            }
            case "double": {
                return Double.TYPE;
            }
            case "boolean": {
                return Boolean.TYPE;
            }
            case "char": {
                return Character.TYPE;
            }
            case "void": {
                return Void.TYPE;
            }
        }
        return Class.forName(cn);
    }

    static {
        genDirectory = JavassistProxyFactory.jvmdowngrader$concat$$clinit$$1(File.separator);
    }

    private static /* synthetic */ String jvmdowngrader$concat$main$1(String string, String string2) {
        return string + string2;
    }

    private static /* synthetic */ String jvmdowngrader$concat$main$1(String string) {
        return "Generating following classes to " + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$modifyProxyFactory$1(String string) {
        return "{return new " + string + ".HikariProxyConnection($$);}";
    }

    private static /* synthetic */ String jvmdowngrader$concat$modifyProxyFactory$2(String string) {
        return "{return new " + string + ".HikariProxyStatement($$);}";
    }

    private static /* synthetic */ String jvmdowngrader$concat$modifyProxyFactory$3(String string) {
        return "{return new " + string + ".HikariProxyPreparedStatement($$);}";
    }

    private static /* synthetic */ String jvmdowngrader$concat$modifyProxyFactory$4(String string) {
        return "{return new " + string + ".HikariProxyCallableStatement($$);}";
    }

    private static /* synthetic */ String jvmdowngrader$concat$modifyProxyFactory$5(String string) {
        return "{return new " + string + ".HikariProxyResultSet($$);}";
    }

    private static /* synthetic */ String jvmdowngrader$concat$modifyProxyFactory$6(String string) {
        return "{return new " + string + ".HikariProxyDatabaseMetaData($$);}";
    }

    private static /* synthetic */ String jvmdowngrader$concat$generateProxyClass$1(String string) {
        return "Generating " + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$$clinit$$1(String string) {
        return "target" + string + "classes";
    }
}

