/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.libs.zaxxer.hikari.util;

import java.lang.reflect.Constructor;
import java.util.Locale;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import me.xginko.aef.libs.zaxxer.hikari.util.IsolationLevel;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

@NestMembers(value={DefaultThreadFactory.class, CustomDiscardPolicy.class})
public final class UtilityElf {
    private static final Pattern PASSWORD_MASKING_PATTERN = Pattern.compile("([?&;][^&#;=]*[pP]assword=)[^&#;]*");

    private UtilityElf() {
    }

    public static String maskPasswordInJdbcUrl(String jdbcUrl) {
        return PASSWORD_MASKING_PATTERN.matcher(jdbcUrl).replaceAll("$1<masked>");
    }

    public static String getNullIfEmpty(String text) {
        return text == null ? null : (text.trim().isEmpty() ? null : text.trim());
    }

    public static void quietlySleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public static boolean safeIsAssignableFrom(Object obj, String className) {
        try {
            Class<?> clazz = Class.forName(className);
            return clazz.isAssignableFrom(obj.getClass());
        }
        catch (ClassNotFoundException ignored) {
            return false;
        }
    }

    public static <T> T createInstance(String className, Class<T> clazz, Object ... args) {
        if (className == null) {
            return null;
        }
        try {
            Class<?> loaded = UtilityElf.class.getClassLoader().loadClass(className);
            int totalArgs = args.length;
            if (totalArgs == 0) {
                return clazz.cast(loaded.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
            Class[] argClasses = new Class[totalArgs];
            for (int i = 0; i < totalArgs; ++i) {
                argClasses[i] = args[i].getClass();
            }
            Constructor<?> constructor = loaded.getConstructor(argClasses);
            return clazz.cast(constructor.newInstance(args));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static ThreadPoolExecutor createThreadPoolExecutor(int queueSize, String threadName, ThreadFactory threadFactory, RejectedExecutionHandler policy) {
        return UtilityElf.createThreadPoolExecutor(new LinkedBlockingQueue<Runnable>(queueSize), threadName, threadFactory, policy);
    }

    public static ThreadPoolExecutor createThreadPoolExecutor(BlockingQueue<Runnable> queue, String threadName, ThreadFactory threadFactory, RejectedExecutionHandler policy) {
        if (threadFactory == null) {
            threadFactory = new DefaultThreadFactory(threadName);
        }
        ThreadPoolExecutor executor = new ThreadPoolExecutor(1, 1, 5L, TimeUnit.SECONDS, queue, threadFactory, policy);
        executor.allowCoreThreadTimeOut(true);
        return executor;
    }

    public static int getTransactionIsolation(String transactionIsolationName) {
        if (transactionIsolationName != null) {
            try {
                String upperCaseIsolationLevelName = transactionIsolationName.toUpperCase(Locale.ENGLISH);
                return IsolationLevel.valueOf(upperCaseIsolationLevelName).getLevelId();
            }
            catch (IllegalArgumentException e) {
                try {
                    int level = Integer.parseInt(transactionIsolationName);
                    for (IsolationLevel iso : IsolationLevel.values()) {
                        if (iso.getLevelId() != level) continue;
                        return iso.getLevelId();
                    }
                    throw new IllegalArgumentException(UtilityElf.jvmdowngrader$concat$getTransactionIsolation$1(transactionIsolationName));
                }
                catch (NumberFormatException nfe) {
                    throw new IllegalArgumentException(UtilityElf.jvmdowngrader$concat$getTransactionIsolation$1(transactionIsolationName), nfe);
                }
            }
        }
        return -1;
    }

    private static /* synthetic */ String jvmdowngrader$concat$getTransactionIsolation$1(String string) {
        return "Invalid transaction isolation value: " + string;
    }

    @NestHost(value=UtilityElf.class)
    public static final class DefaultThreadFactory
    implements ThreadFactory {
        private final String threadName;
        private final boolean daemon;

        public DefaultThreadFactory(String threadName) {
            this.threadName = threadName;
            this.daemon = true;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r, this.threadName);
            thread.setDaemon(this.daemon);
            return thread;
        }
    }

    @NestHost(value=UtilityElf.class)
    public static class CustomDiscardPolicy
    implements RejectedExecutionHandler {
        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
        }
    }
}

