/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules;

import com.google.common.collect.ImmutableSet;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Modifier;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import me.xginko.aef.AnarchyExploitFixes;
import me.xginko.aef.config.Config;
import me.xginko.aef.libs.reflections.Reflections;
import me.xginko.aef.libs.reflections.scanners.Scanner;
import me.xginko.aef.libs.reflections.scanners.Scanners;
import me.xginko.aef.modules.packets.PacketModule;
import me.xginko.aef.utils.models.ConditionalEnableable;
import me.xginko.aef.utils.models.Disableable;

public abstract class AEFModule
implements ConditionalEnableable,
Disableable {
    protected static final Set<Class<AEFModule>> AVAILABLE_MODULES = (Set)new Reflections(AEFModule.class.getPackage().getName(), new Scanner[0]).get(Scanners.SubTypes.of(new AnnotatedElement[]{AEFModule.class}).asClass(new ClassLoader[0])).stream().filter(clazz -> !clazz.isInterface() && !Modifier.isAbstract(clazz.getModifiers())).map(clazz -> clazz).sorted(Comparator.comparing(Class::getSimpleName)).collect(Collectors.collectingAndThen(Collectors.toList(), ImmutableSet::copyOf));
    protected static final Set<AEFModule> ENABLED_MODULES = new HashSet<AEFModule>();
    protected final AnarchyExploitFixes plugin = AnarchyExploitFixes.getInstance();
    protected final Config config = AnarchyExploitFixes.config();
    protected final String configPath;
    protected final String logFormat;
    protected final boolean configEnabled;

    public AEFModule(String configPath) {
        this.configPath = configPath;
        this.configEnabled = false;
        this.logFormat = AEFModule.createLogFormat(configPath);
    }

    public AEFModule(String configPath, boolean defEnabled) {
        this(configPath, defEnabled, null);
    }

    public AEFModule(String configPath, boolean defEnabled, String comment) {
        this.configPath = configPath;
        this.logFormat = AEFModule.createLogFormat(configPath);
        this.configEnabled = comment == null || comment.isEmpty() ? this.config.getBoolean(configPath + ".enable", defEnabled) : this.config.getBoolean(configPath + ".enable", defEnabled, comment);
    }

    private static String createLogFormat(String configPath) {
        String[] paths = configPath.split("\\.");
        return "<" + (paths.length < 3 ? configPath : paths[paths.length - 2] + "." + paths[paths.length - 1]) + "> {}";
    }

    @Override
    public boolean shouldEnable() {
        return this.configEnabled;
    }

    public static void disableAll() {
        for (AEFModule module : ENABLED_MODULES) {
            try {
                module.disable();
            }
            catch (Throwable t2) {
                module.error("Failed during disable. " + t2.getLocalizedMessage());
            }
        }
        ENABLED_MODULES.clear();
    }

    public static void reloadModules() {
        AEFModule.disableAll();
        for (Class<AEFModule> moduleClass : AVAILABLE_MODULES) {
            try {
                AEFModule module = moduleClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                if (!module.shouldEnable()) continue;
                if (module instanceof PacketModule && AnarchyExploitFixes.config().packets_disabled) {
                    module.warn("Cannot enable because you disabled packets in config!");
                    continue;
                }
                ENABLED_MODULES.add(module);
            }
            catch (Throwable t2) {
                if (t2.getCause() instanceof NoClassDefFoundError) {
                    AnarchyExploitFixes.logger().info("Dependencies for module class {} missing, cannot enable.", (Object)moduleClass.getSimpleName());
                    continue;
                }
                AnarchyExploitFixes.logger().warn("Module class '{}' failed to init.", (Object)moduleClass.getSimpleName(), (Object)t2);
            }
        }
        for (AEFModule module : ENABLED_MODULES) {
            try {
                module.enable();
            }
            catch (Throwable t3) {
                module.error("Failed during enable. " + t3.getLocalizedMessage());
                try {
                    module.disable();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    protected void error(String message, Throwable throwable) {
        AnarchyExploitFixes.logger().error(this.logFormat, (Object)message, (Object)throwable);
    }

    protected void error(String message) {
        AnarchyExploitFixes.logger().error(this.logFormat, (Object)message);
    }

    protected void warn(String message) {
        AnarchyExploitFixes.logger().warn(this.logFormat, (Object)message);
    }

    protected void info(String message) {
        AnarchyExploitFixes.logger().info(this.logFormat, (Object)message);
    }

    protected void notRecognized(Class<?> clazz, String unrecognized) {
        this.warn("Unable to parse " + clazz.getSimpleName() + " at '" + unrecognized + "'. Please check your configuration.");
    }
}

