/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.chat;

import com.destroystokyo.paper.event.server.AsyncTabCompleteEvent;
import me.xginko.aef.AnarchyExploitFixes;
import me.xginko.aef.modules.AEFModule;
import me.xginko.aef.utils.permissions.AEFPermission;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.server.TabCompleteEvent;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;

public class PreventPluginScanning
extends AEFModule
implements Listener {
    public PreventPluginScanning() {
        super("chat.prevent-scanning-server-plugins", true, "Prevents hacked clients running .plugins to find out what plugins\nthe server is using.\nRecommended to use in combination with command whitelist.");
    }

    @Override
    public void enable() {
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
    }

    @Override
    public void disable() {
        HandlerList.unregisterAll((Listener)this);
    }

    private boolean isSuspectedScanPacket(String buffer) {
        return buffer.split(" ").length == 1 && !buffer.endsWith(" ") || !buffer.startsWith("/");
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    private void onAsyncCommandTabComplete(AsyncTabCompleteEvent event) {
        if (AnarchyExploitFixes.permissions().permissionValue((Permissible)event.getSender(), AEFPermission.BYPASS_CHAT.node()).toBoolean()) {
            return;
        }
        if (this.isSuspectedScanPacket(event.getBuffer())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    private void onCommandTabComplete(TabCompleteEvent event) {
        if (AnarchyExploitFixes.permissions().permissionValue((Permissible)event.getSender(), AEFPermission.BYPASS_CHAT.node()).toBoolean()) {
            return;
        }
        if (this.isSuspectedScanPacket(event.getBuffer())) {
            event.setCancelled(true);
        }
    }
}

