/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.chat.commandwhitelist;

import com.destroystokyo.paper.event.server.AsyncTabCompleteEvent;
import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.event.PacketListener;
import com.github.retrooper.packetevents.event.PacketListenerAbstract;
import com.github.retrooper.packetevents.event.PacketListenerCommon;
import com.github.retrooper.packetevents.event.PacketListenerPriority;
import com.github.retrooper.packetevents.event.PacketReceiveEvent;
import com.github.retrooper.packetevents.protocol.packettype.PacketType;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import com.github.retrooper.packetevents.wrapper.play.client.WrapperPlayClientChatCommand;
import com.github.retrooper.packetevents.wrapper.play.client.WrapperPlayClientChatMessage;
import com.github.retrooper.packetevents.wrapper.play.client.WrapperPlayClientTabComplete;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerTabComplete;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import me.xginko.aef.AnarchyExploitFixes;
import me.xginko.aef.modules.AEFModule;
import me.xginko.aef.modules.chat.commandwhitelist.CWCommandSendListener;
import me.xginko.aef.utils.CommandUtil;
import me.xginko.aef.utils.permissions.AEFPermission;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.server.TabCompleteEvent;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;

public class CommandWhitelist
extends AEFModule
implements PacketListener,
Listener {
    private final Set<String> allowedCommands;
    private final Set<String> bannedSubCommands;
    private final boolean usePackets;
    private final boolean shouldLog;
    private PacketListenerAbstract packetListenerAbstract;
    private Listener commandSendListener;

    public CommandWhitelist() {
        super("chat.command-whitelist", false, "This will make it pretty much impossible to find your plugins as\nonly the commands you specify will be able to work.\nAllow bypass using permission: " + AEFPermission.BYPASS_CMD_WHITELIST.node());
        this.shouldLog = this.config.getBoolean(this.configPath + ".log", false, "Will show logs when a command was denied.");
        this.usePackets = this.config.getBoolean(this.configPath + ".use-packets", true, "Recommended to use when on 1.12. Otherwise only use if you're having issues.");
        this.allowedCommands = this.config.getList(this.configPath + ".whitelisted-commands", Arrays.asList("help", "vote", "kill", "discord", "togglechat", "toggleconnectionmsgs", "toggletells", "togglewhispering", "toggleprivatemsgs", "ignore", "ignorelist", "ignorehard", "toggledeathmsg", "dmt", "worldstats", "stats", "tps", "msg", "whisper", "w", "m", "t", "pm", "tell", "r", "reply", "last"), "Add all commands you WANT your players to be able to access\nWITHOUT the '/'. Not case sensitive.").stream().map(String::toLowerCase).collect(Collectors.toCollection(HashSet::new));
        this.bannedSubCommands = new HashSet<String>(this.config.getList(this.configPath + ".blacklisted-subcommands", Arrays.asList("help about", "vote List", "vote Best", "vote Total", "worldstats reload", "stats reload"), "Add all subcommands you DON'T want your players to be able\nto access. Case sensitive!"));
    }

    @Override
    public void enable() {
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
        if (CWCommandSendListener.isSupported()) {
            this.commandSendListener = new CWCommandSendListener(this.allowedCommands);
            this.plugin.getServer().getPluginManager().registerEvents(this.commandSendListener, (Plugin)this.plugin);
        }
        if (this.usePackets) {
            if (AnarchyExploitFixes.config().packets_disabled) {
                this.warn("Can't enable packet listener because packet events is disabled in config.");
            } else {
                this.packetListenerAbstract = this.asAbstract(PacketListenerPriority.HIGHEST);
                PacketEvents.getAPI().getEventManager().registerListener((PacketListenerCommon)this.packetListenerAbstract);
            }
        }
    }

    @Override
    public void disable() {
        HandlerList.unregisterAll((Listener)this);
        if (this.commandSendListener != null) {
            HandlerList.unregisterAll((Listener)this.commandSendListener);
            this.commandSendListener = null;
        }
        if (this.packetListenerAbstract != null) {
            PacketEvents.getAPI().getEventManager().unregisterListener((PacketListenerCommon)this.packetListenerAbstract);
            this.packetListenerAbstract = null;
        }
    }

    public void onPacketReceive(PacketReceiveEvent event) {
        Player player;
        String message;
        if (event.isCancelled()) {
            return;
        }
        if (event.getPacketType() == PacketType.Play.Client.TAB_COMPLETE) {
            if (CWCommandSendListener.isSupported()) {
                return;
            }
            Player player2 = (Player)event.getPlayer();
            if (player2 != null && AnarchyExploitFixes.permissions().permissionValue((Permissible)player2, AEFPermission.BYPASS_CMD_WHITELIST.node()).toBoolean()) {
                return;
            }
            String text = new WrapperPlayClientTabComplete(event).getText();
            if (!text.startsWith("/")) {
                return;
            }
            event.setCancelled(true);
            ArrayList<WrapperPlayServerTabComplete.CommandMatch> suggestions = new ArrayList<WrapperPlayServerTabComplete.CommandMatch>();
            for (String allowedCommand : this.allowedCommands) {
                if (text.equals("/")) {
                    suggestions.add(new WrapperPlayServerTabComplete.CommandMatch("/" + allowedCommand, null));
                    continue;
                }
                if (!allowedCommand.startsWith(text.substring(1))) continue;
                suggestions.add(new WrapperPlayServerTabComplete.CommandMatch("/" + allowedCommand, null));
            }
            if (suggestions.isEmpty()) {
                return;
            }
            event.getUser().sendPacket((PacketWrapper)new WrapperPlayServerTabComplete(null, new WrapperPlayServerTabComplete.CommandRange(0, suggestions.size()), suggestions));
            return;
        }
        if (event.getPacketType() == PacketType.Play.Client.CHAT_MESSAGE) {
            message = new WrapperPlayClientChatMessage(event).getMessage();
            if (!message.startsWith("/")) {
                return;
            }
        } else if (event.getPacketType() == PacketType.Play.Client.CHAT_COMMAND) {
            message = new WrapperPlayClientChatCommand(event).getCommand();
        } else {
            return;
        }
        if ((player = (Player)event.getPlayer()) != null && AnarchyExploitFixes.permissions().permissionValue((Permissible)player, AEFPermission.BYPASS_CMD_WHITELIST.node()).toBoolean()) {
            return;
        }
        if (!this.allowedCommands.contains(CommandUtil.getCommandLabel(message).toLowerCase())) {
            event.setCancelled(true);
            if (player != null) {
                player.sendMessage(AnarchyExploitFixes.translation((String)player.getLocale()).chat_CommandWhitelist_BadCommand);
            }
            if (this.shouldLog) {
                this.info(event.getUser().getName() + " tried to execute a non whitelisted command: " + message);
            }
            return;
        }
        for (String bannedSubCommand : this.bannedSubCommands) {
            if (!message.toLowerCase().substring(1).startsWith(bannedSubCommand)) continue;
            event.setCancelled(true);
            if (player != null) {
                player.sendMessage(AnarchyExploitFixes.translation((String)player.getLocale()).chat_CommandWhitelist_BadCommand);
            }
            if (this.shouldLog) {
                this.info(event.getUser().getName() + " tried to execute a blacklisted subcommand: " + message);
            }
            return;
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    private void onCommandPreProcess(PlayerCommandPreprocessEvent event) {
        Player player = event.getPlayer();
        if (AnarchyExploitFixes.permissions().permissionValue((Permissible)player, AEFPermission.BYPASS_CMD_WHITELIST.node()).toBoolean()) {
            return;
        }
        String message = event.getMessage();
        String commandLabel = CommandUtil.getCommandLabel(message).toLowerCase();
        String fullCommand = message.substring(commandLabel.length() + 1);
        fullCommand = "/" + commandLabel + fullCommand;
        event.setMessage(fullCommand);
        if (!this.allowedCommands.contains(commandLabel)) {
            event.setCancelled(true);
            player.sendMessage(AnarchyExploitFixes.translation((String)player.getLocale()).chat_CommandWhitelist_BadCommand);
            if (this.shouldLog) {
                this.info(player.getName() + " tried to execute a non whitelisted command: " + fullCommand);
            }
            return;
        }
        for (String bannedSubCommand : this.bannedSubCommands) {
            if (!message.toLowerCase().substring(1).startsWith(bannedSubCommand)) continue;
            event.setCancelled(true);
            player.sendMessage(AnarchyExploitFixes.translation((String)player.getLocale()).chat_CommandWhitelist_BadCommand);
            if (this.shouldLog) {
                this.info(player.getName() + " tried to execute a blacklisted subcommand: " + message);
            }
            return;
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void onAsyncCommandTabComplete(AsyncTabCompleteEvent event) {
        if (event.getCompletions().isEmpty()) {
            return;
        }
        if (AnarchyExploitFixes.permissions().permissionValue((Permissible)event.getSender(), AEFPermission.BYPASS_CMD_WHITELIST.node()).toBoolean()) {
            return;
        }
        event.setCompletions(this.getFilteredTabCompletions(event.getBuffer(), event.getCompletions()));
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void onCommandTabComplete(TabCompleteEvent event) {
        if (event.getCompletions().isEmpty()) {
            return;
        }
        if (AnarchyExploitFixes.permissions().permissionValue((Permissible)event.getSender(), AEFPermission.BYPASS_CMD_WHITELIST.node()).toBoolean()) {
            return;
        }
        event.setCompletions(this.getFilteredTabCompletions(event.getBuffer(), event.getCompletions()));
    }

    private List<String> getFilteredTabCompletions(String buffer, List<String> suggestions) {
        if (buffer.startsWith("/")) {
            buffer = buffer.substring(1);
        }
        ArrayList<String> suggestionsList = new ArrayList<String>(suggestions);
        if (suggestions.isEmpty() || this.bannedSubCommands.isEmpty()) {
            return suggestionsList;
        }
        for (String bannedSubCommand : this.bannedSubCommands) {
            String scommand = CommandUtil.cutLastArgument(bannedSubCommand);
            if (!buffer.startsWith(scommand)) continue;
            String slast = CommandUtil.getLastArgument(bannedSubCommand);
            while (suggestionsList.contains(slast)) {
                suggestionsList.remove(slast);
            }
        }
        return suggestionsList;
    }
}

