/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.chunklimits;

import java.time.Duration;
import java.util.EnumMap;
import java.util.Map;
import java.util.TreeMap;
import me.xginko.aef.libs.caffeine.cache.Cache;
import me.xginko.aef.libs.caffeine.cache.Caffeine;
import me.xginko.aef.libs.configmaster.api.ConfigSection;
import me.xginko.aef.libs.xseries.XMaterial;
import me.xginko.aef.modules.AEFModule;
import me.xginko.aef.utils.WorldUtil;
import org.bukkit.Chunk;
import org.bukkit.Material;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.plugin.Plugin;

public class BlockLimit
extends AEFModule
implements Listener {
    private final Map<Material, Integer> blockLimits = new EnumMap<Material, Integer>(Material.class);
    private final long materialCountCacheMillis = this.config.getLong(this.configPath + ".material-count-cache-millis", 1000L, "Recommended to not go higher than 5000ms.");
    private Cache<Chunk, Cache<Material, Boolean>> chunkMaterialCache;

    public BlockLimit() {
        super("chunk-limits.block-limit", false);
        EnumMap<XMaterial, Integer> universal = new EnumMap<XMaterial, Integer>(XMaterial.class);
        universal.put(XMaterial.ENCHANTING_TABLE, 16);
        universal.put(XMaterial.ENDER_CHEST, 64);
        universal.put(XMaterial.CHEST, 500);
        universal.put(XMaterial.TRAPPED_CHEST, 200);
        universal.put(XMaterial.DISPENSER, 100);
        universal.put(XMaterial.SLIME_BLOCK, 128);
        universal.put(XMaterial.BEACON, 32);
        universal.put(XMaterial.PISTON, 32);
        universal.put(XMaterial.STICKY_PISTON, 32);
        universal.put(XMaterial.MOVING_PISTON, 32);
        universal.put(XMaterial.PISTON_HEAD, 32);
        universal.put(XMaterial.GLOWSTONE, 5000);
        universal.put(XMaterial.CREEPER_HEAD, 16);
        universal.put(XMaterial.CREEPER_WALL_HEAD, 16);
        universal.put(XMaterial.DRAGON_HEAD, 16);
        universal.put(XMaterial.DRAGON_WALL_HEAD, 16);
        universal.put(XMaterial.PIGLIN_HEAD, 16);
        universal.put(XMaterial.PIGLIN_WALL_HEAD, 16);
        universal.put(XMaterial.PLAYER_HEAD, 16);
        universal.put(XMaterial.PLAYER_WALL_HEAD, 16);
        universal.put(XMaterial.ZOMBIE_HEAD, 16);
        universal.put(XMaterial.ZOMBIE_WALL_HEAD, 16);
        universal.put(XMaterial.ACACIA_HANGING_SIGN, 8);
        universal.put(XMaterial.ACACIA_SIGN, 8);
        universal.put(XMaterial.ACACIA_WALL_HANGING_SIGN, 8);
        universal.put(XMaterial.ACACIA_WALL_SIGN, 8);
        universal.put(XMaterial.BAMBOO_HANGING_SIGN, 8);
        universal.put(XMaterial.BAMBOO_SIGN, 8);
        universal.put(XMaterial.BAMBOO_WALL_HANGING_SIGN, 8);
        universal.put(XMaterial.BAMBOO_WALL_SIGN, 8);
        universal.put(XMaterial.BIRCH_HANGING_SIGN, 8);
        universal.put(XMaterial.BIRCH_SIGN, 8);
        universal.put(XMaterial.BIRCH_WALL_HANGING_SIGN, 8);
        universal.put(XMaterial.BIRCH_WALL_SIGN, 8);
        universal.put(XMaterial.CRIMSON_HANGING_SIGN, 8);
        universal.put(XMaterial.CRIMSON_SIGN, 8);
        universal.put(XMaterial.CRIMSON_WALL_HANGING_SIGN, 8);
        universal.put(XMaterial.CRIMSON_WALL_SIGN, 8);
        universal.put(XMaterial.DARK_OAK_HANGING_SIGN, 8);
        universal.put(XMaterial.DARK_OAK_SIGN, 8);
        universal.put(XMaterial.DARK_OAK_WALL_HANGING_SIGN, 8);
        universal.put(XMaterial.DARK_OAK_WALL_SIGN, 8);
        universal.put(XMaterial.JUNGLE_HANGING_SIGN, 8);
        universal.put(XMaterial.JUNGLE_SIGN, 8);
        universal.put(XMaterial.JUNGLE_WALL_HANGING_SIGN, 8);
        universal.put(XMaterial.JUNGLE_WALL_SIGN, 8);
        universal.put(XMaterial.MANGROVE_HANGING_SIGN, 8);
        universal.put(XMaterial.MANGROVE_SIGN, 8);
        universal.put(XMaterial.MANGROVE_WALL_HANGING_SIGN, 8);
        universal.put(XMaterial.MANGROVE_WALL_SIGN, 8);
        universal.put(XMaterial.OAK_HANGING_SIGN, 8);
        universal.put(XMaterial.OAK_SIGN, 8);
        universal.put(XMaterial.OAK_WALL_HANGING_SIGN, 8);
        universal.put(XMaterial.OAK_WALL_SIGN, 8);
        universal.put(XMaterial.SPRUCE_HANGING_SIGN, 8);
        universal.put(XMaterial.SPRUCE_SIGN, 8);
        universal.put(XMaterial.SPRUCE_WALL_HANGING_SIGN, 8);
        universal.put(XMaterial.SPRUCE_WALL_SIGN, 8);
        universal.put(XMaterial.WARPED_HANGING_SIGN, 8);
        universal.put(XMaterial.WARPED_SIGN, 8);
        universal.put(XMaterial.WARPED_WALL_HANGING_SIGN, 8);
        universal.put(XMaterial.WARPED_WALL_SIGN, 8);
        universal.put(XMaterial.BLACK_BANNER, 12);
        universal.put(XMaterial.BLACK_WALL_BANNER, 12);
        universal.put(XMaterial.BLUE_BANNER, 12);
        universal.put(XMaterial.BLUE_WALL_BANNER, 12);
        universal.put(XMaterial.BROWN_BANNER, 12);
        universal.put(XMaterial.BROWN_WALL_BANNER, 12);
        universal.put(XMaterial.CYAN_BANNER, 12);
        universal.put(XMaterial.CYAN_WALL_BANNER, 12);
        universal.put(XMaterial.GRAY_BANNER, 12);
        universal.put(XMaterial.GRAY_WALL_BANNER, 12);
        universal.put(XMaterial.GREEN_BANNER, 12);
        universal.put(XMaterial.GREEN_WALL_BANNER, 12);
        universal.put(XMaterial.LIGHT_BLUE_BANNER, 12);
        universal.put(XMaterial.LIGHT_BLUE_WALL_BANNER, 12);
        universal.put(XMaterial.LIGHT_GRAY_BANNER, 12);
        universal.put(XMaterial.LIGHT_GRAY_WALL_BANNER, 12);
        universal.put(XMaterial.LIME_BANNER, 12);
        universal.put(XMaterial.LIME_WALL_BANNER, 12);
        universal.put(XMaterial.MAGENTA_BANNER, 12);
        universal.put(XMaterial.MAGENTA_WALL_BANNER, 12);
        universal.put(XMaterial.ORANGE_BANNER, 12);
        universal.put(XMaterial.ORANGE_WALL_BANNER, 12);
        universal.put(XMaterial.PINK_BANNER, 12);
        universal.put(XMaterial.PINK_WALL_BANNER, 12);
        universal.put(XMaterial.PURPLE_BANNER, 12);
        universal.put(XMaterial.PURPLE_WALL_BANNER, 12);
        universal.put(XMaterial.RED_BANNER, 12);
        universal.put(XMaterial.RED_WALL_BANNER, 12);
        universal.put(XMaterial.YELLOW_BANNER, 12);
        universal.put(XMaterial.YELLOW_WALL_BANNER, 12);
        TreeMap<String, Object> compatible = new TreeMap<String, Object>();
        for (Map.Entry entry : universal.entrySet()) {
            if (!((XMaterial)entry.getKey()).isSupported()) continue;
            compatible.put(((XMaterial)entry.getKey()).get().name(), entry.getValue());
        }
        ConfigSection section = this.config.getConfigSection(this.configPath + ".max-blocks-per-chunk", compatible, "Attempt to prevent ChunkBan / Client FPS Lag");
        for (String configuredMaterial : section.getKeys(false)) {
            try {
                Material blockMaterial = Material.valueOf((String)configuredMaterial);
                Integer maxAmountPerChunk = Integer.parseInt(section.getString(configuredMaterial));
                this.blockLimits.put(blockMaterial, maxAmountPerChunk);
            }
            catch (NumberFormatException e) {
                this.notRecognized(Integer.class, configuredMaterial);
            }
            catch (IllegalArgumentException e) {
                this.notRecognized(Material.class, configuredMaterial);
            }
        }
    }

    @Override
    public void enable() {
        this.chunkMaterialCache = Caffeine.newBuilder().expireAfterWrite(Duration.ofMinutes(1L)).build();
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
    }

    @Override
    public void disable() {
        HandlerList.unregisterAll((Listener)this);
        if (this.chunkMaterialCache != null) {
            for (Map.Entry entry : this.chunkMaterialCache.asMap().entrySet()) {
                ((Cache)entry.getValue()).invalidateAll();
                ((Cache)entry.getValue()).cleanUp();
            }
            this.chunkMaterialCache.invalidateAll();
            this.chunkMaterialCache.cleanUp();
            this.chunkMaterialCache = null;
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void onBlockPlace(BlockPlaceEvent event) {
        if (this.blockLimits.containsKey(event.getBlock().getType()) && this.exceedsPerChunkLimit(event.getBlock().getType(), event.getBlock().getChunk())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void onPlayerInteract(PlayerInteractEvent event) {
        if (event.getAction() == Action.LEFT_CLICK_AIR || event.getAction() == Action.LEFT_CLICK_BLOCK) {
            return;
        }
        if (this.blockLimits.containsKey(event.getMaterial()) && this.exceedsPerChunkLimit(event.getMaterial(), event.getPlayer().getChunk())) {
            event.setCancelled(true);
        }
    }

    private boolean exceedsPerChunkLimit(Material blockType, Chunk chunk) {
        int limit = this.blockLimits.get(blockType);
        int minY = WorldUtil.getMinWorldHeight(chunk.getWorld());
        int maxY = chunk.getWorld().getMaxHeight();
        Cache<Object, Boolean> exceededCache = this.chunkMaterialCache.getIfPresent(chunk);
        if (exceededCache == null) {
            exceededCache = Caffeine.newBuilder().expireAfterWrite(Duration.ofMillis(this.materialCountCacheMillis)).build();
        }
        Boolean exceeded = exceededCache.get(blockType, material -> {
            int count = 0;
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    for (int y = minY; y < maxY; ++y) {
                        if (chunk.getBlock(x, y, z).getType() != material || ++count <= limit) continue;
                        return true;
                    }
                }
            }
            return false;
        });
        this.chunkMaterialCache.put(chunk, exceededCache);
        return exceeded;
    }
}

