/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.chunklimits;

import java.util.EnumMap;
import java.util.Map;
import java.util.TreeMap;
import me.xginko.aef.libs.configmaster.api.ConfigSection;
import me.xginko.aef.libs.xseries.XEntityType;
import me.xginko.aef.modules.AEFModule;
import me.xginko.aef.utils.ChunkUtil;
import me.xginko.aef.utils.LocationUtil;
import org.bukkit.Chunk;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntitySpawnEvent;
import org.bukkit.event.world.ChunkUnloadEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class CustomEntityLimit
extends AEFModule
implements Runnable,
Listener {
    private final Map<EntityType, Integer> entityLimits = new EnumMap<EntityType, Integer>(EntityType.class);
    private final long checkPeriod;
    private final boolean logIsEnabled = this.config.getBoolean(this.configPath + ".log-removals", true);
    private BukkitTask bukkitTask;

    public CustomEntityLimit() {
        super("chunk-limits.entity-limits.custom-limit", false, "Limit specific entity types per chunk.\nRead over the defaults at least once before enabling.");
        this.checkPeriod = this.config.getInt(this.configPath + ".check-period-in-ticks", 1200, "Check all loaded chunks every x ticks.");
        EnumMap<XEntityType, Integer> defaults = new EnumMap<XEntityType, Integer>(XEntityType.class);
        defaults.put(XEntityType.ARROW, 20);
        defaults.put(XEntityType.FIREBALL, 5);
        defaults.put(XEntityType.SMALL_FIREBALL, 5);
        defaults.put(XEntityType.SNOWBALL, 5);
        defaults.put(XEntityType.WITHER, 16);
        defaults.put(XEntityType.WITHER_SKULL, 10);
        defaults.put(XEntityType.BLAZE, 10);
        defaults.put(XEntityType.CREEPER, 10);
        defaults.put(XEntityType.ENDERMAN, 10);
        defaults.put(XEntityType.MAGMA_CUBE, 10);
        defaults.put(XEntityType.PHANTOM, 10);
        defaults.put(XEntityType.SLIME, 10);
        defaults.put(XEntityType.SKELETON, 10);
        defaults.put(XEntityType.STRAY, 10);
        defaults.put(XEntityType.WITHER_SKELETON, 10);
        defaults.put(XEntityType.SPIDER, 10);
        defaults.put(XEntityType.CAVE_SPIDER, 10);
        defaults.put(XEntityType.ZOMBIE, 10);
        defaults.put(XEntityType.DROWNED, 10);
        defaults.put(XEntityType.HUSK, 10);
        defaults.put(XEntityType.PIGLIN_BRUTE, 10);
        defaults.put(XEntityType.ZOMBIFIED_PIGLIN, 20);
        defaults.put(XEntityType.HOGLIN, 10);
        defaults.put(XEntityType.ZOGLIN, 10);
        defaults.put(XEntityType.CHICKEN, 10);
        defaults.put(XEntityType.PIG, 10);
        defaults.put(XEntityType.SHEEP, 10);
        defaults.put(XEntityType.COW, 10);
        defaults.put(XEntityType.MOOSHROOM, 10);
        defaults.put(XEntityType.WOLF, 10);
        defaults.put(XEntityType.DONKEY, 10);
        defaults.put(XEntityType.HORSE, 10);
        defaults.put(XEntityType.MULE, 10);
        defaults.put(XEntityType.SKELETON_HORSE, 10);
        defaults.put(XEntityType.ZOMBIE_HORSE, 10);
        defaults.put(XEntityType.GOAT, 10);
        defaults.put(XEntityType.LLAMA, 10);
        defaults.put(XEntityType.TRADER_LLAMA, 10);
        defaults.put(XEntityType.BAT, 3);
        defaults.put(XEntityType.CAT, 10);
        defaults.put(XEntityType.OCELOT, 3);
        defaults.put(XEntityType.DOLPHIN, 4);
        defaults.put(XEntityType.ENDERMITE, 3);
        defaults.put(XEntityType.FOX, 10);
        defaults.put(XEntityType.PANDA, 5);
        defaults.put(XEntityType.PARROT, 10);
        defaults.put(XEntityType.POLAR_BEAR, 5);
        defaults.put(XEntityType.RABBIT, 5);
        defaults.put(XEntityType.SILVERFISH, 3);
        defaults.put(XEntityType.STRIDER, 3);
        defaults.put(XEntityType.EVOKER, 15);
        defaults.put(XEntityType.VEX, 15);
        defaults.put(XEntityType.PILLAGER, 15);
        defaults.put(XEntityType.VINDICATOR, 15);
        defaults.put(XEntityType.WITCH, 15);
        defaults.put(XEntityType.RAVAGER, 15);
        defaults.put(XEntityType.AXOLOTL, 10);
        defaults.put(XEntityType.COD, 6);
        defaults.put(XEntityType.SALMON, 6);
        defaults.put(XEntityType.TROPICAL_FISH, 6);
        defaults.put(XEntityType.PUFFERFISH, 3);
        defaults.put(XEntityType.SQUID, 20);
        defaults.put(XEntityType.GLOW_SQUID, 20);
        defaults.put(XEntityType.FROG, 20);
        defaults.put(XEntityType.TADPOLE, 20);
        defaults.put(XEntityType.ALLAY, 20);
        defaults.put(XEntityType.BEE, 15);
        defaults.put(XEntityType.TURTLE, 20);
        defaults.put(XEntityType.GUARDIAN, 20);
        defaults.put(XEntityType.PIGLIN, 25);
        defaults.put(XEntityType.IRON_GOLEM, 15);
        defaults.put(XEntityType.ZOMBIE_VILLAGER, 25);
        defaults.put(XEntityType.WANDERING_TRADER, 10);
        TreeMap<String, Object> compatibleDef = new TreeMap<String, Object>();
        for (Map.Entry entry : defaults.entrySet()) {
            if (!((XEntityType)entry.getKey()).isSupported()) continue;
            compatibleDef.put(((XEntityType)entry.getKey()).get().name(), entry.getValue());
        }
        ConfigSection section = this.config.getConfigSection(this.configPath + ".limited-types", compatibleDef, "Check the paper api for correct EntityType enums:\nhttps://jd.papermc.io/paper/1.20/org/bukkit/entity/EntityType.html\nMake sure your minecraft version is matching as well.");
        for (String configuredEntity : section.getKeys(false)) {
            try {
                EntityType limitedEntity = EntityType.valueOf((String)configuredEntity);
                Integer maxAmountPerChunk = Integer.parseInt(section.getString(configuredEntity));
                this.entityLimits.put(limitedEntity, maxAmountPerChunk);
            }
            catch (NumberFormatException e) {
                this.notRecognized(Integer.class, configuredEntity);
            }
            catch (IllegalArgumentException e) {
                this.notRecognized(Material.class, configuredEntity);
            }
        }
    }

    @Override
    public void enable() {
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
        this.bukkitTask = this.plugin.getServer().getScheduler().runTaskTimer((Plugin)this.plugin, (Runnable)this, this.checkPeriod, this.checkPeriod);
    }

    @Override
    public void disable() {
        HandlerList.unregisterAll((Listener)this);
        if (this.bukkitTask != null) {
            this.bukkitTask.cancel();
            this.bukkitTask = null;
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void onChunkUnload(ChunkUnloadEvent event) {
        if (ChunkUtil.isRetrievalUnsafe(event.getChunk())) {
            return;
        }
        for (Map.Entry<EntityType, Integer> limit : this.entityLimits.entrySet()) {
            int maxAllowedPerChunk = limit.getValue();
            int entityCount = 0;
            for (Entity entity : event.getChunk().getEntities()) {
                if (entity.getType() != limit.getKey() || ++entityCount <= maxAllowedPerChunk) continue;
                entity.remove();
                if (!this.logIsEnabled) continue;
                this.info("Removed entity " + entity.getType() + " at " + LocationUtil.toString(entity.getLocation()) + " because reached limit of " + maxAllowedPerChunk);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void onSpawn(EntitySpawnEvent event) {
        if (!this.entityLimits.containsKey(event.getEntityType())) {
            return;
        }
        int maxAllowedPerChunk = this.entityLimits.get(event.getEntityType());
        int entityCount = 1;
        for (Entity entity : event.getEntity().getChunk().getEntities()) {
            if (entity.getType() != event.getEntityType() || ++entityCount <= maxAllowedPerChunk) continue;
            entity.remove();
            if (!this.logIsEnabled) continue;
            this.info("Removed entity " + entity.getType() + " at " + LocationUtil.toString(entity.getLocation()) + " because reached limit of " + maxAllowedPerChunk);
        }
    }

    @Override
    public void run() {
        for (World world : this.plugin.getServer().getWorlds()) {
            for (Chunk chunk : world.getLoadedChunks()) {
                if (ChunkUtil.isRetrievalUnsafe(chunk) || !ChunkUtil.isEntitiesLoaded(chunk)) continue;
                Entity[] chunkEntities = chunk.getEntities();
                for (Map.Entry<EntityType, Integer> limit : this.entityLimits.entrySet()) {
                    int maxAllowedPerChunk = limit.getValue();
                    int entityCount = 0;
                    for (Entity entity : chunkEntities) {
                        if (entity.getType() != limit.getKey() || ++entityCount <= maxAllowedPerChunk) continue;
                        entity.remove();
                        if (!this.logIsEnabled) continue;
                        this.info("Removed entity " + entity.getType() + " at " + LocationUtil.toString(entity.getLocation()) + " because reached limit of " + maxAllowedPerChunk);
                    }
                }
            }
        }
    }
}

