/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.chunklimits;

import java.time.Duration;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import me.xginko.aef.libs.caffeine.cache.Cache;
import me.xginko.aef.libs.caffeine.cache.Caffeine;
import me.xginko.aef.libs.xseries.XEntityType;
import me.xginko.aef.modules.AEFModule;
import me.xginko.aef.utils.ChunkUtil;
import me.xginko.aef.utils.LocationUtil;
import me.xginko.aef.utils.MaterialUtil;
import me.xginko.aef.utils.models.ChunkUID;
import org.bukkit.Chunk;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.ItemSpawnEvent;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class DroppedItemLimit
extends AEFModule
implements Listener,
Runnable {
    private final Set<Material> whitelistedTypes;
    private final long checkPeriod;
    private final long cleanupDelayTicks;
    private final int maxDroppedItemsPerChunk;
    private final boolean logIsEnabled;
    private final boolean usingWhitelist;
    private final boolean onChunkLoad;
    private Cache<ChunkUID, BukkitTask> scheduledChecks;
    private BukkitTask bukkitTask;

    public DroppedItemLimit() {
        super("chunk-limits.entity-limits.dropped-item-limit", false, "Limit the amount of dropped items in a chunk to combat lag.\nBe aware this does not prioritize items by value or anything,\nit just deletes whatever happens to get over the limit during\ncounting.");
        this.logIsEnabled = this.config.getBoolean(this.configPath + ".log-removals", true);
        this.maxDroppedItemsPerChunk = this.config.getInt(this.configPath + ".max-dropped-items-per-chunk", 200);
        this.cleanupDelayTicks = Math.max(1, this.config.getInt(this.configPath + ".post-item-drop-check-delay", 60, "The delay in ticks the plugin will wait after an item in a chunk\nhas dropped before the check logic will run.\nThis improves performance as there will be no check for each single\nitem entity that spawns."));
        this.checkPeriod = this.config.getInt(this.configPath + ".check-period-in-ticks", 1200, "The period in ticks in which all loaded chunks should be regularly\nchecked. Keep in mind: A lower number provides more accuracy but is\nalso worse for performance.");
        this.onChunkLoad = this.config.getBoolean(this.configPath + ".check-on-chunk-load", true, "Runs item check when a chunk is loaded.");
        this.usingWhitelist = this.config.getBoolean(this.configPath + ".whitelist-specific-item-types", false);
        this.whitelistedTypes = this.config.getList(this.configPath + ".whitelisted-types", MaterialUtil.SHULKER_BOXES.get().stream().map(Enum::name).sorted().collect(Collectors.toList()), "Check the paper api for correct Material enums:\nhttps://jd.papermc.io/paper/1.20.6/org/bukkit/Material.html\nMake sure your minecraft version is matching as well.").stream().map(configuredType -> {
            try {
                return Material.valueOf((String)configuredType);
            }
            catch (IllegalArgumentException e) {
                this.notRecognized(Material.class, (String)configuredType);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toCollection(() -> EnumSet.noneOf(Material.class)));
    }

    @Override
    public void enable() {
        this.scheduledChecks = Caffeine.newBuilder().expireAfterWrite(Duration.ofMillis(this.cleanupDelayTicks * 50L)).build();
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
        this.bukkitTask = this.plugin.getServer().getScheduler().runTaskTimer((Plugin)this.plugin, (Runnable)this, this.checkPeriod, this.checkPeriod);
    }

    @Override
    public void disable() {
        HandlerList.unregisterAll((Listener)this);
        if (this.bukkitTask != null) {
            this.bukkitTask.cancel();
            this.bukkitTask = null;
        }
        if (this.scheduledChecks != null) {
            this.scheduledChecks.asMap().forEach((uid, task) -> task.cancel());
            this.scheduledChecks.invalidateAll();
            this.scheduledChecks.cleanUp();
            this.scheduledChecks = null;
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void onItemDrop(ItemSpawnEvent event) {
        Chunk chunk = event.getEntity().getChunk();
        this.scheduledChecks.get(ChunkUID.of(chunk), chunkUID -> this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            if (!ChunkUtil.isEntitiesLoaded(chunk)) {
                return;
            }
            int droppedItemCount = 0;
            for (Entity entity : chunk.getEntities()) {
                if (entity.getType() != XEntityType.ITEM.get() || ++droppedItemCount <= this.maxDroppedItemsPerChunk || this.usingWhitelist && this.whitelistedTypes.contains(((Item)entity).getItemStack().getType())) continue;
                entity.remove();
                if (!this.logIsEnabled) continue;
                this.info("Removed dropped item at " + LocationUtil.toString(entity.getLocation()) + " because reached limit of " + this.maxDroppedItemsPerChunk);
            }
        }, this.cleanupDelayTicks));
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void onChunkLoad(ChunkLoadEvent event) {
        if (!this.onChunkLoad || event.isNewChunk()) {
            return;
        }
        if (ChunkUtil.isRetrievalUnsafe(event.getChunk())) {
            return;
        }
        int droppedItemCount = 0;
        for (Entity entity : event.getChunk().getEntities()) {
            if (entity.getType() != XEntityType.ITEM.get() || ++droppedItemCount <= this.maxDroppedItemsPerChunk || this.usingWhitelist && this.whitelistedTypes.contains(((Item)entity).getItemStack().getType())) continue;
            entity.remove();
            if (!this.logIsEnabled) continue;
            this.info("Removed dropped item at " + LocationUtil.toString(entity.getLocation()) + " because reached limit of " + this.maxDroppedItemsPerChunk);
        }
    }

    @Override
    public void run() {
        for (World world : this.plugin.getServer().getWorlds()) {
            for (Chunk chunk : world.getLoadedChunks()) {
                if (ChunkUtil.isRetrievalUnsafe(chunk) || !ChunkUtil.isEntitiesLoaded(chunk)) continue;
                int droppedItemCount = 0;
                for (Entity entity : chunk.getEntities()) {
                    if (entity.getType() != XEntityType.ITEM.get() || ++droppedItemCount <= this.maxDroppedItemsPerChunk || this.usingWhitelist && this.whitelistedTypes.contains(((Item)entity).getItemStack().getType())) continue;
                    entity.remove();
                    if (!this.logIsEnabled) continue;
                    this.info("Removed dropped item at " + LocationUtil.toString(entity.getLocation()) + " because reached limit of " + this.maxDroppedItemsPerChunk);
                }
            }
        }
    }
}

