/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.chunklimits;

import me.xginko.aef.modules.AEFModule;
import me.xginko.aef.utils.ChunkUtil;
import me.xginko.aef.utils.EntityUtil;
import me.xginko.aef.utils.LocationUtil;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.vehicle.VehicleCreateEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class MinecartLimit
extends AEFModule
implements Listener,
Runnable {
    private final long checkPeriod;
    private final int maxMinecartsPerChunk;
    private final boolean logIsEnabled;
    private BukkitTask bukkitTask;

    public MinecartLimit() {
        super("chunk-limits.minecart-limit", false, "Limit the amount of minecarts to prevent lag caused by collisions.");
        this.logIsEnabled = this.config.getBoolean(this.configPath + ".log-removals", false);
        this.maxMinecartsPerChunk = this.config.getInt(this.configPath + ".max-minecarts-per-chunk", 25);
        this.checkPeriod = Math.max(1, this.config.getInt(this.configPath + ".check-period-in-ticks", 400, "200 ticks = 10 seconds."));
    }

    @Override
    public void enable() {
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
        this.bukkitTask = this.plugin.getServer().getScheduler().runTaskTimer((Plugin)this.plugin, (Runnable)this, this.checkPeriod, this.checkPeriod);
    }

    @Override
    public void disable() {
        HandlerList.unregisterAll((Listener)this);
        if (this.bukkitTask != null) {
            this.bukkitTask.cancel();
            this.bukkitTask = null;
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void onCreate(VehicleCreateEvent event) {
        Vehicle vehicle = event.getVehicle();
        if (!EntityUtil.MINECARTS.get().contains(vehicle.getType())) {
            return;
        }
        int minecartCount = 1;
        for (Entity entity : vehicle.getChunk().getEntities()) {
            if (!EntityUtil.MINECARTS.get().contains(entity.getType()) || ++minecartCount <= this.maxMinecartsPerChunk) continue;
            entity.remove();
            if (!this.logIsEnabled) continue;
            this.info("Removed minecart " + entity.getType() + " at " + LocationUtil.toString(entity.getLocation()) + " because reached limit of " + this.maxMinecartsPerChunk);
        }
    }

    @Override
    public void run() {
        for (World world : this.plugin.getServer().getWorlds()) {
            for (Chunk chunk : world.getLoadedChunks()) {
                if (ChunkUtil.isRetrievalUnsafe(chunk) || !ChunkUtil.isEntitiesLoaded(chunk)) continue;
                int minecartCount = 0;
                for (Entity entity : chunk.getEntities()) {
                    if (!EntityUtil.MINECARTS.get().contains(entity.getType()) || ++minecartCount <= this.maxMinecartsPerChunk) continue;
                    entity.remove();
                    if (!this.logIsEnabled) continue;
                    this.info("Removed minecart " + entity.getType() + " at " + LocationUtil.toString(entity.getLocation()) + " because reached limit of " + this.maxMinecartsPerChunk);
                }
            }
        }
    }
}

