/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.chunklimits;

import me.xginko.aef.libs.xseries.XEntityType;
import me.xginko.aef.modules.AEFModule;
import me.xginko.aef.utils.ChunkUtil;
import me.xginko.aef.utils.EntityUtil;
import me.xginko.aef.utils.LocationUtil;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntitySpawnEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class NonLivingEntityLimit
extends AEFModule
implements Listener,
Runnable {
    private final long checkPeriod;
    private final int maxNonLivingEntities;
    private final boolean logIsEnabled;
    private BukkitTask bukkitTask;

    public NonLivingEntityLimit() {
        super("chunk-limits.entity-limits.non-living-limit", false, "Limit the amount of non living entities in a chunk to prevent lag.\nIgnores dropped items.");
        this.logIsEnabled = this.config.getBoolean(this.configPath + ".log-removals", true);
        this.maxNonLivingEntities = this.config.getInt(this.configPath + ".max-non-living-per-chunk", 100);
        this.checkPeriod = Math.max(1, this.config.getInt(this.configPath + ".check-period-in-ticks", 20, "20 ticks = 1 second"));
    }

    @Override
    public void enable() {
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
        this.bukkitTask = this.plugin.getServer().getScheduler().runTaskTimer((Plugin)this.plugin, (Runnable)this, this.checkPeriod, this.checkPeriod);
    }

    @Override
    public void disable() {
        HandlerList.unregisterAll((Listener)this);
        if (this.bukkitTask != null) {
            this.bukkitTask.cancel();
            this.bukkitTask = null;
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void onSpawn(EntitySpawnEvent event) {
        if (event.getEntityType() == XEntityType.ITEM.get() || EntityUtil.isLivingEntity(event.getEntity())) {
            return;
        }
        int nonLivingCount = 1;
        for (Entity entity : event.getEntity().getChunk().getEntities()) {
            if (entity.getType().equals((Object)EntityType.DROPPED_ITEM) || EntityUtil.isLivingEntity(entity) || ++nonLivingCount <= this.maxNonLivingEntities) continue;
            entity.remove();
            if (!this.logIsEnabled) continue;
            this.info("Removed non-living entity " + entity.getType() + " at " + LocationUtil.toString(entity.getLocation()) + " because reached limit of " + this.maxNonLivingEntities);
        }
    }

    @Override
    public void run() {
        for (World world : this.plugin.getServer().getWorlds()) {
            for (Chunk chunk : world.getLoadedChunks()) {
                if (ChunkUtil.isRetrievalUnsafe(chunk) || !ChunkUtil.isEntitiesLoaded(chunk)) continue;
                int nonLivingCount = 0;
                for (Entity entity : chunk.getEntities()) {
                    if (entity.getType() == XEntityType.ITEM.get() || EntityUtil.isLivingEntity(entity) || ++nonLivingCount <= this.maxNonLivingEntities) continue;
                    entity.remove();
                    if (!this.logIsEnabled) continue;
                    this.info("Removed non-living entity " + entity.getType() + " at " + LocationUtil.toString(entity.getLocation()) + " because reached limit of " + this.maxNonLivingEntities);
                }
            }
        }
    }
}

