/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.chunklimits;

import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.xginko.aef.libs.xseries.XEntityType;
import me.xginko.aef.libs.xseries.base.XBase;
import me.xginko.aef.modules.AEFModule;
import me.xginko.aef.utils.ChunkUtil;
import me.xginko.aef.utils.EntityUtil;
import me.xginko.aef.utils.LocationUtil;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class ProjectileLimit
extends AEFModule
implements Runnable,
Listener {
    private final Set<EntityType> exemptEntities;
    private final long checkPeriod;
    private final int maxProjectilesPerChunk;
    private final boolean logIsEnabled;
    private BukkitTask bukkitTask;

    public ProjectileLimit() {
        super("chunk-limits.projectile-limit", true, "Prevent players from crashing the server or other players by\ncreating a ton of projectile entities, then loading them at once.");
        this.logIsEnabled = this.config.getBoolean(this.configPath + ".log", false);
        this.maxProjectilesPerChunk = this.config.getInt(this.configPath + ".max-projectiles-per-chunk", 25);
        this.checkPeriod = this.config.getInt(this.configPath + ".check-period-in-ticks", 800, "20 ticks = 1 second");
        List<String> defaults = Stream.of(XEntityType.ENDER_PEARL, XEntityType.FISHING_BOBBER).filter(XBase::isSupported).map(XEntityType::get).map(Enum::name).collect(Collectors.toList());
        this.exemptEntities = this.config.getList(this.configPath + ".whitelisted-types", defaults).stream().map(configuredEntity -> {
            try {
                return EntityType.valueOf((String)configuredEntity);
            }
            catch (IllegalArgumentException e) {
                this.notRecognized(EntityType.class, (String)configuredEntity);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toCollection(() -> EnumSet.noneOf(EntityType.class)));
    }

    @Override
    public void enable() {
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
        this.bukkitTask = this.plugin.getServer().getScheduler().runTaskTimer((Plugin)this.plugin, (Runnable)this, this.checkPeriod, this.checkPeriod);
    }

    @Override
    public void disable() {
        HandlerList.unregisterAll((Listener)this);
        if (this.bukkitTask != null) {
            this.bukkitTask.cancel();
            this.bukkitTask = null;
        }
    }

    private void onProjectileEvent(EntityEvent event) {
        int projectilesCount = 1;
        for (Entity entity : event.getEntity().getChunk().getEntities()) {
            if (this.exemptEntities.contains(entity.getType()) || !EntityUtil.isProjectile(entity) || ++projectilesCount <= this.maxProjectilesPerChunk) continue;
            entity.remove();
            if (!this.logIsEnabled) continue;
            this.info("Removed projectile " + entity.getType() + " at " + LocationUtil.toString(entity.getLocation()) + " because reached limit of " + this.maxProjectilesPerChunk);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void onProjectileLaunch(ProjectileLaunchEvent event) {
        this.onProjectileEvent((EntityEvent)event);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void onProjectileHit(ProjectileHitEvent event) {
        this.onProjectileEvent((EntityEvent)event);
    }

    @Override
    public void run() {
        for (World world : this.plugin.getServer().getWorlds()) {
            for (Chunk chunk : world.getLoadedChunks()) {
                if (ChunkUtil.isRetrievalUnsafe(chunk) || !ChunkUtil.isEntitiesLoaded(chunk)) continue;
                int droppedItemCount = 0;
                for (Entity entity : chunk.getEntities()) {
                    if (this.exemptEntities.contains(entity.getType()) || !EntityUtil.isProjectile(entity) || ++droppedItemCount <= this.maxProjectilesPerChunk) continue;
                    entity.remove();
                    if (!this.logIsEnabled) continue;
                    this.info("Removed projectile at " + LocationUtil.toString(entity.getLocation()) + " because reached limit of " + this.maxProjectilesPerChunk);
                }
            }
        }
    }
}

