/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.chunklimits;

import me.xginko.aef.libs.xseries.XMaterial;
import me.xginko.aef.modules.AEFModule;
import me.xginko.aef.utils.ChunkUtil;
import me.xginko.aef.utils.LocationUtil;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.block.BlockState;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class TileEntityLimit
extends AEFModule
implements Runnable,
Listener {
    private final long checkPeriod;
    private final int maxTileEntities;
    private final boolean logIsEnabled;
    private BukkitTask bukkitTask;

    public TileEntityLimit() {
        super("chunk-limits.entity-limits.tile-entity-limit", false, "Limit the amount of tile entities in a chunk to prevent lag.");
        this.logIsEnabled = this.config.getBoolean(this.configPath + ".log-removals", true);
        this.maxTileEntities = this.config.getInt(this.configPath + ".max-tile-entities-per-chunk", 100);
        this.checkPeriod = this.config.getInt(this.configPath + ".check-period-in-ticks", 20);
    }

    @Override
    public void enable() {
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
        this.bukkitTask = this.plugin.getServer().getScheduler().runTaskTimer((Plugin)this.plugin, (Runnable)this, this.checkPeriod, this.checkPeriod);
    }

    @Override
    public void disable() {
        HandlerList.unregisterAll((Listener)this);
        if (this.bukkitTask != null) {
            this.bukkitTask.cancel();
            this.bukkitTask = null;
        }
    }

    @Override
    public void run() {
        for (World world : this.plugin.getServer().getWorlds()) {
            for (Chunk chunk : world.getLoadedChunks()) {
                if (ChunkUtil.isRetrievalUnsafe(chunk)) continue;
                BlockState[] tileEntities = chunk.getTileEntities();
                int amountToRemove = tileEntities.length - this.maxTileEntities;
                if (amountToRemove <= 0) {
                    return;
                }
                for (int i = 0; i < amountToRemove; ++i) {
                    tileEntities[i].setType(XMaterial.AIR.get());
                    tileEntities[i].update(true, false);
                    if (!this.logIsEnabled) continue;
                    this.info("Removed tile entity at " + LocationUtil.toString(tileEntities[i].getLocation()) + " because reached limit of " + this.maxTileEntities);
                }
            }
        }
    }
}

