/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.chunklimits;

import me.xginko.aef.modules.AEFModule;
import me.xginko.aef.utils.ChunkUtil;
import me.xginko.aef.utils.EntityUtil;
import me.xginko.aef.utils.LocationUtil;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.vehicle.VehicleCreateEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class VehicleLimit
extends AEFModule
implements Listener,
Runnable {
    private final long checkPeriod;
    private final int maxVehiclesPerChunk;
    private final boolean logIsEnabled;
    private BukkitTask bukkitTask;

    public VehicleLimit() {
        super("chunk-limits.vehicle-limit", false, "Limit the amount of vehicles to prevent some lag machines.\nex. dispenser that spawns a lot of boats into a single location\nthen hitting it, causing all boats to explode in every direction.");
        this.logIsEnabled = this.config.getBoolean(this.configPath + ".log-removals", false);
        this.maxVehiclesPerChunk = this.config.getInt(this.configPath + ".max-vehicles-per-chunk", 25);
        this.checkPeriod = Math.max(1, this.config.getInt(this.configPath + ".check-period-in-ticks", 400, "200 ticks = 10 seconds."));
    }

    @Override
    public void enable() {
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
        this.bukkitTask = this.plugin.getServer().getScheduler().runTaskTimer((Plugin)this.plugin, (Runnable)this, this.checkPeriod, this.checkPeriod);
    }

    @Override
    public void disable() {
        HandlerList.unregisterAll((Listener)this);
        if (this.bukkitTask != null) {
            this.bukkitTask.cancel();
            this.bukkitTask = null;
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void onCreate(VehicleCreateEvent event) {
        int vehicleCount = 1;
        for (Entity entity : event.getVehicle().getChunk().getEntities()) {
            if (!EntityUtil.isVehicle(entity) || ++vehicleCount <= this.maxVehiclesPerChunk) continue;
            entity.remove();
            if (!this.logIsEnabled) continue;
            this.info("Removed vehicle " + entity.getType() + " at " + LocationUtil.toString(entity.getLocation()) + " because reached limit of " + this.maxVehiclesPerChunk);
        }
    }

    @Override
    public void run() {
        for (World world : this.plugin.getServer().getWorlds()) {
            for (Chunk chunk : world.getLoadedChunks()) {
                if (ChunkUtil.isRetrievalUnsafe(chunk) || !ChunkUtil.isEntitiesLoaded(chunk)) continue;
                int vehicleCount = 0;
                for (Entity entity : chunk.getEntities()) {
                    if (!EntityUtil.isVehicle(entity) || ++vehicleCount <= this.maxVehiclesPerChunk) continue;
                    entity.remove();
                    if (!this.logIsEnabled) continue;
                    this.info("Removed vehicle " + entity.getType() + " at " + LocationUtil.toString(entity.getLocation()) + " because reached limit of " + this.maxVehiclesPerChunk);
                }
            }
        }
    }
}

