/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.combat.auras;

import me.xginko.aef.libs.xseries.XMaterial;
import me.xginko.aef.modules.combat.auras.AuraDelayModule;
import me.xginko.aef.utils.WorldUtil;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.player.PlayerInteractEvent;

public class AnchorAuraDelay
extends AuraDelayModule {
    public AnchorAuraDelay() {
        super("combat.anchor-aura-delay", 0L, 400L);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void onPlayerInteract(PlayerInteractEvent event) {
        if (this.breakDelayNanos <= 0L) {
            return;
        }
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (event.getClickedBlock().getType() != XMaterial.RESPAWN_ANCHOR.get()) {
            return;
        }
        if (event.getItem() == null || event.getItem().getType() != XMaterial.GLOWSTONE.get()) {
            return;
        }
        if (WorldUtil.isRespawnAnchorWorks(event.getPlayer().getWorld())) {
            return;
        }
        if (this.isOnCooldown(event.getPlayer().getUniqueId(), this.breakCooldowns, this.breakDelayNanos)) {
            event.setCancelled(true);
            if (this.updateInventory) {
                event.getPlayer().updateInventory();
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void onBlockPlace(BlockPlaceEvent event) {
        if (this.placeDelayNanos <= 0L) {
            return;
        }
        if (event.getBlock().getType() != XMaterial.RESPAWN_ANCHOR.get()) {
            return;
        }
        if (WorldUtil.isRespawnAnchorWorks(event.getPlayer().getWorld())) {
            return;
        }
        if (this.isOnCooldown(event.getPlayer().getUniqueId(), this.placeCooldowns, this.placeDelayNanos)) {
            event.setCancelled(true);
            if (this.updateInventory) {
                event.getPlayer().updateInventory();
            }
        }
    }
}

