/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.combat.auras;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import me.xginko.aef.modules.AEFModule;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public abstract class AuraDelayModule
extends AEFModule
implements Listener {
    protected final long placeDelayNanos;
    protected final long breakDelayNanos;
    protected final boolean updateInventory;
    protected Map<UUID, Long> placeCooldowns;
    protected Map<UUID, Long> breakCooldowns;

    public AuraDelayModule(String configPath, long defPlaceDelayMillis, long defBreakDelayMillis) {
        this(configPath, false, defPlaceDelayMillis, defBreakDelayMillis);
    }

    public AuraDelayModule(String configPath, boolean defEnabled, long defPlaceDelayMillis, long defBreakDelayMillis) {
        super(configPath, defEnabled);
        this.updateInventory = this.config.getBoolean(configPath + ".update-inventory-on-cancel", false, "Can help with desync but recommended to leave off unless you have issues.");
        this.placeDelayNanos = TimeUnit.MILLISECONDS.toNanos(this.config.getLong(configPath + ".place-delay-millis", defPlaceDelayMillis, "1 tick = 50 ms"));
        this.breakDelayNanos = TimeUnit.MILLISECONDS.toNanos(this.config.getLong(configPath + ".break-delay-millis", defBreakDelayMillis));
    }

    @Override
    public void enable() {
        this.breakCooldowns = new ConcurrentHashMap<UUID, Long>();
        this.placeCooldowns = new ConcurrentHashMap<UUID, Long>();
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
    }

    @Override
    public void disable() {
        HandlerList.unregisterAll((Listener)this);
        if (this.breakCooldowns != null) {
            this.breakCooldowns.clear();
            this.breakCooldowns = null;
        }
        if (this.placeCooldowns != null) {
            this.placeCooldowns.clear();
            this.placeCooldowns = null;
        }
    }

    protected boolean isOnCooldown(UUID uuid, Map<UUID, Long> cooldownMap, long delayNanos) {
        if (delayNanos <= 0L) {
            return false;
        }
        if (cooldownMap.containsKey(uuid) && cooldownMap.get(uuid) > System.nanoTime()) {
            return true;
        }
        cooldownMap.put(uuid, System.nanoTime() + delayNanos);
        return false;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    private void onPlayerQuit(PlayerQuitEvent event) {
        this.placeCooldowns.remove(event.getPlayer().getUniqueId());
        this.breakCooldowns.remove(event.getPlayer().getUniqueId());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    private void onPlayerKick(PlayerKickEvent event) {
        this.placeCooldowns.remove(event.getPlayer().getUniqueId());
        this.breakCooldowns.remove(event.getPlayer().getUniqueId());
    }
}

