/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.dupepreventions;

import me.xginko.aef.libs.xseries.XEntityType;
import me.xginko.aef.modules.AEFModule;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.vehicle.VehicleEnterEvent;
import org.bukkit.plugin.Plugin;

public class AllayDupe
extends AEFModule
implements Listener {
    private final boolean dismount;

    public AllayDupe() {
        super("dupe-preventions.allay-dupe", true, "Will prevent allays from entering vehicles to prevent a duplication exploit\nconfirmed working in 1.19.4.");
        this.dismount = this.config.getBoolean(this.configPath + ".dismount-premounted-allays", true);
    }

    @Override
    public void enable() {
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
    }

    @Override
    public void disable() {
        HandlerList.unregisterAll((Listener)this);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void onVehicleEnter(VehicleEnterEvent event) {
        if (event.getEntered().getType() == XEntityType.ALLAY.get()) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void onEntityPickupItem(EntityPickupItemEvent event) {
        if (event.getEntityType() != XEntityType.ALLAY.get()) {
            return;
        }
        if (event.getEntity().isInsideVehicle()) {
            event.setCancelled(true);
            if (this.dismount) {
                this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> event.getEntity().leaveVehicle(), 10L);
            }
        }
    }
}

