/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.dupepreventions;

import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import me.xginko.aef.libs.xseries.XMaterial;
import me.xginko.aef.modules.AEFModule;
import me.xginko.aef.utils.MaterialUtil;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPistonEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.plugin.Plugin;

public class BlockEntityDupe
extends AEFModule
implements Listener {
    private final Map<Material, Boolean> materials = new EnumMap<Material, Boolean>(Material.class);
    private Set<Block> removalList;

    public BlockEntityDupe() {
        super("dupe-preventions.block-entity-dupe", false, "Will prevent Pistons that are pushing carpets/rails/tnt from working.\nThis isn't recommended to be used for turning everything off.\nUse papers settings for that.\nThis is intended for admins that want to allow specific dupes only.");
        boolean remove;
        if (this.config.getBoolean(this.configPath + ".carpets.prevent", true)) {
            remove = this.config.getBoolean(this.configPath + ".carpets.delete", true);
            for (Material material : MaterialUtil.CARPETS.get()) {
                this.materials.put(material, remove);
            }
        }
        if (this.config.getBoolean(this.configPath + ".rails.prevent", true)) {
            remove = this.config.getBoolean(this.configPath + ".rails.delete", true);
            for (Material material : MaterialUtil.RAILS.get()) {
                this.materials.put(material, remove);
            }
        }
        if (this.config.getBoolean(this.configPath + ".tnt.prevent", false)) {
            this.materials.put(XMaterial.TNT.get(), this.config.getBoolean(this.configPath + ".tnt.delete", true));
        }
    }

    @Override
    public void enable() {
        this.removalList = Collections.newSetFromMap(new ConcurrentHashMap());
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
    }

    @Override
    public void disable() {
        HandlerList.unregisterAll((Listener)this);
        if (this.removalList != null) {
            this.setBlocksToAir();
            this.removalList = null;
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void onPistonExtend(BlockPistonExtendEvent event) {
        this.onPistonEvent((BlockPistonEvent)event, event.getBlocks());
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void onPistonRetract(BlockPistonRetractEvent event) {
        this.onPistonEvent((BlockPistonEvent)event, event.getBlocks());
    }

    private void onPistonEvent(BlockPistonEvent event, List<Block> affectedBlocks) {
        if (affectedBlocks.isEmpty()) {
            return;
        }
        for (Block block : affectedBlocks) {
            if (!this.materials.containsKey(block.getType())) continue;
            event.setCancelled(true);
            if (!this.materials.get(block.getType()).booleanValue()) continue;
            this.removalList.add(block);
        }
        this.setBlocksToAir();
    }

    private void setBlocksToAir() {
        if (this.removalList.isEmpty()) {
            return;
        }
        this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            for (Block block : this.removalList) {
                block.setType(XMaterial.AIR.get(), false);
                this.removalList.remove(block);
            }
        }, 1L);
    }
}

