/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.dupepreventions;

import me.xginko.aef.modules.AEFModule;
import me.xginko.aef.utils.EntityUtil;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.plugin.Plugin;

public class CloseEntityInventoriesOnLogout
extends AEFModule
implements Listener {
    public CloseEntityInventoriesOnLogout() {
        super("dupe-preventions.close-entity-inventories-on-player-disconnect", false, "Closes open inventories of entities that disappeared when the\nplayer riding it disconnects.");
    }

    @Override
    public void enable() {
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
    }

    @Override
    public void disable() {
        HandlerList.unregisterAll((Listener)this);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    private void onPlayerQuit(PlayerQuitEvent event) {
        Entity vehicle = event.getPlayer().getVehicle();
        if (EntityUtil.isInventoryHolder(vehicle)) {
            for (HumanEntity viewer : ((InventoryHolder)vehicle).getInventory().getViewers()) {
                viewer.closeInventory();
            }
        }
    }
}

