/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.dupepreventions;

import me.xginko.aef.modules.AEFModule;
import me.xginko.aef.utils.EntityUtil;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.world.ChunkUnloadEvent;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.plugin.Plugin;

public class CloseEntityInventoryOnChunkUnload
extends AEFModule
implements Listener {
    public CloseEntityInventoryOnChunkUnload() {
        super("dupe-preventions.close-entity-inventories-on-chunk-unload", false, "Closes open inventories of all entities that are in a chunk\nthat will be unloaded.");
    }

    @Override
    public void enable() {
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
    }

    @Override
    public void disable() {
        HandlerList.unregisterAll((Listener)this);
    }

    @EventHandler(priority=EventPriority.LOW)
    private void onChunkUnload(ChunkUnloadEvent event) {
        for (Entity entity : event.getChunk().getEntities()) {
            if (!EntityUtil.isInventoryHolder(entity)) continue;
            for (HumanEntity viewer : ((InventoryHolder)entity).getInventory().getViewers()) {
                viewer.closeInventory();
            }
        }
    }
}

