/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.dupepreventions;

import me.xginko.aef.modules.AEFModule;
import me.xginko.aef.utils.EntityUtil;
import org.bukkit.World;
import org.bukkit.entity.ChestedHorse;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.plugin.Plugin;

public class EndPortalDupe
extends AEFModule
implements Listener {
    public EndPortalDupe() {
        super("dupe-preventions.prevent-end-portal-dupe", false, "Patches a dupe that involves pushing a chestable entity\nwith low hp into an end portal, duplicating its inventory\ncontent on death");
    }

    @Override
    public void enable() {
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
    }

    @Override
    public void disable() {
        HandlerList.unregisterAll((Listener)this);
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    private void onEntityDamage(EntityDamageEvent event) {
        if (event.getCause() == EntityDamageEvent.DamageCause.ENTITY_ATTACK || event.getCause() == EntityDamageEvent.DamageCause.FALL) {
            return;
        }
        if (event.getEntity().getWorld().getEnvironment() != World.Environment.THE_END) {
            return;
        }
        if (event.getEntity().getType() == EntityType.PLAYER) {
            return;
        }
        if (!EntityUtil.isLivingEntity(event.getEntity())) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)event.getEntity();
        if ((livingEntity.getCanPickupItems() || EntityUtil.isChestableHorse((Entity)livingEntity) && ((ChestedHorse)livingEntity).isCarryingChest()) && livingEntity.getHealth() - event.getDamage() <= 0.0 && Math.round(livingEntity.getLocation().getX()) == 100L && Math.round(livingEntity.getLocation().getZ()) == 0L) {
            livingEntity.remove();
        }
    }
}

