/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.elytra;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.event.PacketListener;
import com.github.retrooper.packetevents.event.PacketListenerAbstract;
import com.github.retrooper.packetevents.event.PacketListenerCommon;
import com.github.retrooper.packetevents.event.PacketListenerPriority;
import com.github.retrooper.packetevents.event.PacketReceiveEvent;
import com.github.retrooper.packetevents.protocol.packettype.PacketType;
import com.github.retrooper.packetevents.protocol.world.Location;
import com.github.retrooper.packetevents.wrapper.play.client.WrapperPlayClientPlayerFlying;
import java.lang.invoke.LambdaMetafactory;
import java.time.Duration;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import me.xginko.aef.AnarchyExploitFixes;
import me.xginko.aef.modules.AEFModule;
import me.xginko.aef.utils.ChunkUtil;
import me.xginko.aef.utils.LocationUtil;
import me.xginko.aef.utils.models.ExpiringSet;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.NumberConversions;
import org.jetbrains.annotations.NotNull;

public class ElytraHelper
extends AEFModule
implements Runnable,
PacketListener,
Listener {
    private static ElytraHelper instance;
    private final long speed_as_ticks;
    private Map<UUID, PlayerData> playerDataMap;
    private PacketListenerAbstract packetListener;
    private NewChunksListener newChunksListener;
    private ScheduledExecutorService executorService;
    private ScheduledFuture<?> scheduledTask;

    public ElytraHelper() {
        super("elytra.elytra-speed");
        this.speed_as_ticks = this.config.elytra_speed_calc_period_millis / 50L;
        instance = this;
    }

    public static ElytraHelper getInstance() {
        return instance;
    }

    public static boolean isNetherCeiling(org.bukkit.Location location) {
        return location.getWorld().getEnvironment() == World.Environment.NETHER && location.getY() > (double)AnarchyExploitFixes.config().nether_ceiling_max_y;
    }

    @Override
    public void enable() {
        this.playerDataMap = new ConcurrentHashMap<UUID, PlayerData>();
        this.packetListener = this.asAbstract(PacketListenerPriority.MONITOR);
        PacketEvents.getAPI().getEventManager().registerListener((PacketListenerCommon)this.packetListener);
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
        this.executorService = Executors.newScheduledThreadPool(1);
        this.scheduledTask = this.executorService.scheduleAtFixedRate(this, 50L, this.config.elytra_speed_calc_period_millis, TimeUnit.MILLISECONDS);
        if (!ChunkUtil.canGetInhabitedTime()) {
            this.newChunksListener = new NewChunksListener();
            this.plugin.getServer().getPluginManager().registerEvents((Listener)this.newChunksListener, (Plugin)this.plugin);
        }
    }

    @Override
    public void disable() {
        HandlerList.unregisterAll((Listener)this);
        if (this.newChunksListener != null) {
            HandlerList.unregisterAll((Listener)this.newChunksListener);
            this.newChunksListener = null;
        }
        if (this.packetListener != null) {
            PacketEvents.getAPI().getEventManager().unregisterListener((PacketListenerCommon)this.packetListener);
            this.packetListener = null;
        }
        if (this.playerDataMap != null) {
            this.playerDataMap.clear();
            this.playerDataMap = null;
        }
        if (this.scheduledTask != null) {
            this.scheduledTask.cancel(true);
            this.scheduledTask = null;
        }
        if (this.executorService != null) {
            this.executorService.shutdownNow();
            this.executorService = null;
        }
    }

    @Override
    public boolean shouldEnable() {
        return this.config.elytra_enable_at_spawn || this.config.elytra_enable_global || this.config.elytra_enable_netherceiling;
    }

    @Override
    public void run() {
        for (Map.Entry<UUID, PlayerData> entry : this.playerDataMap.entrySet()) {
            entry.getValue().calcSpeedAvg(this.config.elytra_calculate_3D, this.speed_as_ticks);
        }
    }

    public void onPacketReceive(PacketReceiveEvent event) {
        if (event.isCancelled() || event.getUser() == null) {
            return;
        }
        if (event.getUser().getUUID() == null || !this.playerDataMap.containsKey(event.getUser().getUUID())) {
            return;
        }
        if (event.getPacketType() == PacketType.Play.Client.PLAYER_FLYING || event.getPacketType() == PacketType.Play.Client.PLAYER_POSITION || event.getPacketType() == PacketType.Play.Client.PLAYER_POSITION_AND_ROTATION) {
            this.playerDataMap.get(event.getUser().getUUID()).updateLatestPosition(new WrapperPlayClientPlayerFlying(event).getLocation());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    private void onPlayerMove(PlayerMoveEvent event) {
        if (event.getPlayer().isGliding()) {
            this.playerDataMap.computeIfAbsent(event.getPlayer().getUniqueId(), k -> new PlayerData(event.getFrom(), event.getTo())).updateLatestPosition(event.getTo());
        } else {
            this.playerDataMap.remove(event.getPlayer().getUniqueId());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    private void onWorldChange(PlayerChangedWorldEvent event) {
        if (this.playerDataMap.containsKey(event.getPlayer().getUniqueId())) {
            this.playerDataMap.get(event.getPlayer().getUniqueId()).updateLatestPosition(event.getPlayer().getLocation());
        }
    }

    public double getBlocksPerTick(PlayerMoveEvent event) {
        return this.playerDataMap.computeIfAbsent(event.getPlayer().getUniqueId(), k -> new PlayerData(event.getFrom(), event.getTo())).getSpeedAvg();
    }

    public org.bukkit.Location getSetbackLocation(PlayerMoveEvent event) {
        return this.playerDataMap.computeIfAbsent((UUID)event.getPlayer().getUniqueId(), (Function<UUID, PlayerData>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$getSetbackLocation$2(org.bukkit.event.player.PlayerMoveEvent java.util.UUID ), (Ljava/util/UUID;)Lme/xginko/aef/modules/elytra/ElytraHelper$PlayerData;)((PlayerMoveEvent)event)).previous;
    }

    public boolean isInNewChunks(Player player) {
        if (ChunkUtil.canGetInhabitedTime()) {
            return ChunkUtil.getInhabitedTime(player.getChunk()) <= this.config.elytra_old_chunk_limit;
        }
        return this.newChunksListener.isInNewChunks(player.getUniqueId());
    }

    private static /* synthetic */ PlayerData lambda$getSetbackLocation$2(PlayerMoveEvent event, UUID k) {
        return new PlayerData(event.getFrom(), event.getTo());
    }

    private static class NewChunksListener
    implements Listener {
        private final Set<UUID> new_chunk_players = new ExpiringSet<UUID>(Duration.ofMinutes(10L));

        @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
        private void onChunkLoad(ChunkLoadEvent event) {
            for (Player player : event.getWorld().getPlayers()) {
                if (!(ChunkUtil.getChunkDistanceSquared(event.getChunk(), player.getLocation()) < NumberConversions.square((double)player.getViewDistance()))) continue;
                if (event.isNewChunk()) {
                    this.new_chunk_players.add(player.getUniqueId());
                    continue;
                }
                this.new_chunk_players.remove(player.getUniqueId());
            }
        }

        public boolean isInNewChunks(UUID player) {
            return this.new_chunk_players.contains(player);
        }
    }

    private static class PlayerData {
        @NotNull
        public org.bukkit.Location previous;
        @NotNull
        public org.bukkit.Location latest;
        private double speedAvg;

        public PlayerData(@NotNull org.bukkit.Location previous, @NotNull org.bukkit.Location latest) {
            this.previous = previous;
            this.latest = latest;
        }

        public double getSpeedAvg() {
            return this.speedAvg;
        }

        public void updateLatestPosition(Location location) {
            this.latest.setX(location.getX());
            this.latest.setY(location.getY());
            this.latest.setZ(location.getZ());
        }

        public void updateLatestPosition(org.bukkit.Location location) {
            this.latest.setWorld(location.getWorld());
            this.latest.setX(location.getX());
            this.latest.setY(location.getY());
            this.latest.setZ(location.getZ());
        }

        public void calcSpeedAvg(boolean using3D, long tickPeriod) {
            this.speedAvg = using3D ? LocationUtil.getRelativeDistance3D(this.previous, this.latest) : LocationUtil.getRelativeDistance2D(this.previous, this.latest) / (double)tickPeriod;
            this.previous = this.latest.clone();
        }
    }
}

