/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.elytra;

import me.xginko.aef.AnarchyExploitFixes;
import me.xginko.aef.config.Translation;
import me.xginko.aef.modules.AEFModule;
import me.xginko.aef.modules.elytra.ElytraHelper;
import me.xginko.aef.utils.MaterialUtil;
import me.xginko.aef.utils.permissions.AEFPermission;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;

public class ElytraOnCeiling
extends AEFModule
implements Listener {
    private final double ceiling_SpeedOldChunks;
    private final double ceiling_SpeedNewChunks;
    private final double ceiling_BurstSpeedOldChunks;
    private final double ceiling_BurstSpeedNewChunks;
    private final double ceiling_BurstOldChunk_TPS;
    private final double ceiling_BurstNewChunk_TPS;
    private final double ceiling_DenyElytraTPS;
    private final boolean ceiling_DenyElytra;
    private final boolean ceiling_EnableBursting;
    private final boolean ceiling_DenyOnLowTPS;
    private final boolean ceiling_AlsoRemoveOnLowTPS;

    public ElytraOnCeiling() {
        super("elytra.elytra-speed.Nether-Ceiling", false, "Use separate values for players above the nether ceiling.");
        this.ceiling_DenyElytra = this.config.getBoolean(this.configPath + ".deny-elytra-usage", false);
        this.ceiling_SpeedOldChunks = this.config.getDouble(this.configPath + ".speed-old-chunks", 0.5);
        this.ceiling_SpeedNewChunks = this.config.getDouble(this.configPath + ".speed-new-chunks", 0.5);
        this.ceiling_EnableBursting = this.config.getBoolean(this.configPath + ".enable-bursting", true);
        this.ceiling_BurstSpeedOldChunks = this.config.getDouble(this.configPath + ".burst-speed-old-chunks", 1.0);
        this.ceiling_BurstOldChunk_TPS = this.config.getDouble(this.configPath + ".burst-speed-old-chunk-TPS", 18.0);
        this.ceiling_BurstSpeedNewChunks = this.config.getDouble(this.configPath + ".burst-speed-new-chunks", 1.0);
        this.ceiling_BurstNewChunk_TPS = this.config.getDouble(this.configPath + ".burst-speed-new-chunk-TPS", 18.0);
        this.ceiling_DenyOnLowTPS = this.config.getBoolean(this.configPath + ".deny-elytra-on-low-TPS", true);
        this.ceiling_DenyElytraTPS = this.config.getDouble(this.configPath + ".deny-elytra-TPS", 12.0);
        this.ceiling_AlsoRemoveOnLowTPS = this.config.getBoolean(this.configPath + ".also-remove-elytra-on-low-TPS", true);
    }

    @Override
    public void enable() {
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
    }

    @Override
    public boolean shouldEnable() {
        return this.config.elytra_enable_netherceiling;
    }

    @Override
    public void disable() {
        HandlerList.unregisterAll((Listener)this);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void onPlayerMove(PlayerMoveEvent event) {
        Player player = event.getPlayer();
        if (!player.isGliding()) {
            return;
        }
        if (AnarchyExploitFixes.permissions().permissionValue((Permissible)player, AEFPermission.BYPASS_ELYTRA.node()).toBoolean()) {
            return;
        }
        Location playerLoc = player.getLocation();
        if (!ElytraHelper.isNetherCeiling(playerLoc)) {
            return;
        }
        if (this.ceiling_DenyElytra) {
            if (this.config.elytra_teleport_back) {
                player.teleport(ElytraHelper.getInstance().getSetbackLocation(event));
            } else {
                event.setCancelled(true);
            }
            if (this.config.elytra_play_too_fast_sound) {
                player.playSound(player.getEyeLocation(), this.config.elytra_too_fast_sound, 1.0f, 1.0f);
            }
            if (this.config.elytra_actionbar_enabled) {
                player.sendActionBar(AnarchyExploitFixes.translation((String)player.getLocale()).elytra_ceiling_DisabledHere);
            }
            return;
        }
        if (this.ceiling_DenyOnLowTPS && AnarchyExploitFixes.tickReporter().getTPS() <= this.ceiling_DenyElytraTPS) {
            PlayerInventory playerInv;
            if (this.config.elytra_teleport_back) {
                player.teleport(ElytraHelper.getInstance().getSetbackLocation(event));
            } else {
                event.setCancelled(true);
            }
            if (this.config.elytra_play_too_fast_sound) {
                player.playSound(player.getEyeLocation(), this.config.elytra_too_fast_sound, 1.0f, 1.0f);
            }
            if (this.config.elytra_actionbar_enabled) {
                player.sendActionBar(AnarchyExploitFixes.translation((String)player.getLocale()).elytra_ceiling_DisabledLowTPS.replace("%tps%", String.valueOf(this.ceiling_DenyElytraTPS)));
            }
            if (this.ceiling_AlsoRemoveOnLowTPS && MaterialUtil.isElytra((playerInv = player.getInventory()).getChestplate())) {
                ItemStack elytra = playerInv.getChestplate();
                playerInv.setChestplate(null);
                player.getWorld().dropItemNaturally(playerLoc, elytra);
            }
            return;
        }
        double flySpeed = ElytraHelper.getInstance().getBlocksPerTick(event);
        if (ElytraHelper.getInstance().isInNewChunks(player)) {
            if (this.ceiling_EnableBursting && AnarchyExploitFixes.tickReporter().getTPS() >= this.ceiling_BurstNewChunk_TPS) {
                if (flySpeed > this.ceiling_BurstSpeedNewChunks) {
                    if (this.config.elytra_teleport_back) {
                        player.teleport(ElytraHelper.getInstance().getSetbackLocation(event));
                    } else {
                        event.setCancelled(true);
                    }
                    if (this.config.elytra_play_too_fast_sound) {
                        player.playSound(player.getEyeLocation(), this.config.elytra_too_fast_sound, 1.0f, 1.0f);
                    }
                    if (!this.config.elytra_actionbar_enabled) {
                        return;
                    }
                    Translation lang = AnarchyExploitFixes.translation(player.getLocale());
                    if (this.config.elytra_show_chunk_age) {
                        player.sendActionBar(lang.elytra_ceiling_TooFastChunkInfo.replace("%neworold%", lang.elytra_ceiling_New).replace("%chunks%", lang.elytra_ceiling_Chunks));
                    } else {
                        player.sendActionBar(lang.elytra_ceiling_TooFast);
                    }
                } else {
                    if (!this.config.elytra_actionbar_enabled) {
                        return;
                    }
                    Translation lang = AnarchyExploitFixes.translation(player.getLocale());
                    if (this.config.elytra_show_chunk_age) {
                        player.sendActionBar(lang.elytra_ceiling_YouAreFlyingIn.replace("%neworold%", lang.elytra_ceiling_New_Color + lang.elytra_ceiling_New.toUpperCase()).replace("%chunks%", lang.elytra_ceiling_Chunks) + " " + lang.elytra_ceiling_Speed.replace("%maxspeed%", String.valueOf(this.ceiling_BurstSpeedNewChunks)).replace("%speed%", String.format("%.2f", flySpeed)));
                    } else {
                        player.sendActionBar(lang.elytra_ceiling_Speed.replace("%speed%", String.format("%.2f", flySpeed)).replace("%maxspeed%", String.valueOf(this.ceiling_BurstSpeedNewChunks)));
                    }
                }
            } else if (flySpeed > this.ceiling_SpeedNewChunks) {
                if (this.config.elytra_teleport_back) {
                    player.teleport(ElytraHelper.getInstance().getSetbackLocation(event));
                } else {
                    event.setCancelled(true);
                }
                if (this.config.elytra_play_too_fast_sound) {
                    player.playSound(player.getEyeLocation(), this.config.elytra_too_fast_sound, 1.0f, 1.0f);
                }
                if (!this.config.elytra_actionbar_enabled) {
                    return;
                }
                Translation lang = AnarchyExploitFixes.translation(player.getLocale());
                if (this.ceiling_EnableBursting) {
                    player.sendActionBar(lang.elytra_ceiling_TooFastLowTPS);
                } else if (this.config.elytra_show_chunk_age) {
                    player.sendActionBar(lang.elytra_ceiling_TooFastChunkInfo.replace("%neworold%", lang.elytra_ceiling_New).replace("%chunks%", lang.elytra_ceiling_Chunks));
                } else {
                    player.sendActionBar(lang.elytra_ceiling_TooFast);
                }
            } else {
                if (!this.config.elytra_actionbar_enabled) {
                    return;
                }
                Translation lang = AnarchyExploitFixes.translation(player.getLocale());
                if (this.config.elytra_show_chunk_age) {
                    player.sendActionBar(lang.elytra_ceiling_YouAreFlyingIn.replace("%neworold%", lang.elytra_ceiling_New_Color + lang.elytra_ceiling_New.toUpperCase()).replace("%chunks%", lang.elytra_ceiling_Chunks) + " " + lang.elytra_ceiling_Speed.replace("%maxspeed%", String.valueOf(this.ceiling_SpeedOldChunks)).replace("%speed%", String.format("%.2f", flySpeed)));
                } else {
                    player.sendActionBar(lang.elytra_ceiling_Speed.replace("%speed%", String.format("%.2f", flySpeed)).replace("%maxspeed%", String.valueOf(this.ceiling_SpeedOldChunks)));
                }
            }
        } else if (this.ceiling_EnableBursting && AnarchyExploitFixes.tickReporter().getTPS() >= this.ceiling_BurstOldChunk_TPS) {
            if (flySpeed > this.ceiling_BurstSpeedOldChunks) {
                if (this.config.elytra_teleport_back) {
                    player.teleport(ElytraHelper.getInstance().getSetbackLocation(event));
                } else {
                    event.setCancelled(true);
                }
                if (this.config.elytra_play_too_fast_sound) {
                    player.playSound(player.getEyeLocation(), this.config.elytra_too_fast_sound, 1.0f, 1.0f);
                }
                if (!this.config.elytra_actionbar_enabled) {
                    return;
                }
                Translation lang = AnarchyExploitFixes.translation(player.getLocale());
                if (this.config.elytra_show_chunk_age) {
                    player.sendActionBar(lang.elytra_ceiling_TooFastChunkInfo.replace("%neworold%", lang.elytra_ceiling_Old).replace("%chunks%", lang.elytra_ceiling_Chunks));
                } else {
                    player.sendActionBar(lang.elytra_ceiling_TooFast);
                }
            } else {
                if (!this.config.elytra_actionbar_enabled) {
                    return;
                }
                Translation lang = AnarchyExploitFixes.translation(player.getLocale());
                if (this.config.elytra_show_chunk_age) {
                    player.sendActionBar(lang.elytra_ceiling_YouAreFlyingIn.replace("%neworold%", lang.elytra_ceiling_Old_Color + lang.elytra_ceiling_Old.toUpperCase()).replace("%chunks%", lang.elytra_ceiling_Chunks) + " " + lang.elytra_ceiling_Speed.replace("%maxspeed%", String.valueOf(this.ceiling_BurstSpeedOldChunks)).replace("%speed%", String.format("%.2f", flySpeed)));
                } else {
                    player.sendActionBar(lang.elytra_ceiling_Speed.replace("%speed%", String.format("%.2f", flySpeed)).replace("%maxspeed%", String.valueOf(this.ceiling_BurstSpeedOldChunks)));
                }
            }
        } else if (flySpeed > this.ceiling_SpeedOldChunks) {
            if (this.config.elytra_teleport_back) {
                player.teleport(ElytraHelper.getInstance().getSetbackLocation(event));
            } else {
                event.setCancelled(true);
            }
            if (this.config.elytra_play_too_fast_sound) {
                player.playSound(player.getEyeLocation(), this.config.elytra_too_fast_sound, 1.0f, 1.0f);
            }
            if (!this.config.elytra_actionbar_enabled) {
                return;
            }
            Translation lang = AnarchyExploitFixes.translation(player.getLocale());
            if (this.ceiling_EnableBursting) {
                player.sendActionBar(lang.elytra_ceiling_TooFastLowTPS);
            } else if (this.config.elytra_show_chunk_age) {
                player.sendActionBar(lang.elytra_ceiling_TooFastChunkInfo.replace("%neworold%", lang.elytra_ceiling_Old).replace("%chunks%", lang.elytra_ceiling_Chunks));
            } else {
                player.sendActionBar(lang.elytra_ceiling_TooFast);
            }
        } else {
            if (!this.config.elytra_actionbar_enabled) {
                return;
            }
            Translation lang = AnarchyExploitFixes.translation(player.getLocale());
            if (this.config.elytra_show_chunk_age) {
                player.sendActionBar(lang.elytra_ceiling_YouAreFlyingIn.replace("%neworold%", lang.elytra_ceiling_Old_Color + lang.elytra_ceiling_Old.toUpperCase()).replace("%chunks%", lang.elytra_ceiling_Chunks) + " " + lang.elytra_ceiling_Speed.replace("%maxspeed%", String.valueOf(this.ceiling_SpeedOldChunks)).replace("%speed%", String.format("%.2f", flySpeed)));
            } else {
                player.sendActionBar(lang.elytra_ceiling_Speed.replace("%speed%", String.format("%.2f", flySpeed)).replace("%maxspeed%", String.valueOf(this.ceiling_SpeedOldChunks)));
            }
        }
    }
}

