/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.illegals.items;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import me.xginko.aef.modules.illegals.items.IllegalItemModule;
import me.xginko.aef.utils.enums.IllegalHandling;
import me.xginko.aef.utils.enums.ItemLegality;
import me.xginko.aef.utils.permissions.AEFPermission;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jetbrains.annotations.NotNull;

public class BannedItemNames
extends IllegalItemModule {
    private final Set<Pattern> bannedRegex;
    private final Set<Material> whitelistedTypes;
    private final boolean delete;

    public BannedItemNames() {
        super("illegals.banned-item-names", false, AEFPermission.BYPASS_ILLEGAL_BANNEDNAME, "Bypass permission: " + AEFPermission.BYPASS_ILLEGAL_BANNEDNAME.node() + "\nResets an item's name (or deletes the item) if it matches one of\nthe configured regexes.\nRegexes can be complex. Use a tool like https://regex101.com/ or\nChatGPT for good results.");
        this.delete = this.config.getBoolean(this.configPath + ".delete-item", false, "Will delete the item instead of resetting the name.");
        this.bannedRegex = this.config.getList(this.configPath + ".regex", Collections.singletonList("(?i)illegalstring")).stream().map(Pattern::compile).collect(Collectors.toCollection(HashSet::new));
        this.whitelistedTypes = this.config.getList(this.configPath + ".whitelisted-items", Collections.singletonList("DIRT")).stream().map(configuredType -> {
            try {
                return Material.valueOf((String)configuredType);
            }
            catch (IllegalArgumentException e) {
                this.notRecognized(Material.class, (String)configuredType);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toCollection(() -> EnumSet.noneOf(Material.class)));
    }

    @Override
    @NotNull
    public ItemLegality legalityOf(@Nullable ItemStack itemStack) {
        if (itemStack == null || this.whitelistedTypes.contains(itemStack.getType()) || !itemStack.hasItemMeta() || !itemStack.getItemMeta().hasDisplayName()) {
            return ItemLegality.LEGAL;
        }
        String displayName = itemStack.getItemMeta().getDisplayName();
        for (Pattern pattern : this.bannedRegex) {
            if (!pattern.matcher(displayName).find()) continue;
            return ItemLegality.ILLEGAL;
        }
        return ItemLegality.LEGAL;
    }

    @Override
    public void handleItem(ItemStack itemStack, ItemLegality legality) {
        if (this.illegalHandling == IllegalHandling.PREVENT_USE_ONLY) {
            return;
        }
        if (legality == ItemLegality.ILLEGAL) {
            if (this.delete) {
                itemStack.setAmount(0);
            } else {
                ItemMeta meta = itemStack.getItemMeta();
                meta.setDisplayName(null);
                itemStack.setItemMeta(meta);
            }
        }
    }
}

