/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.illegals.items;

import com.destroystokyo.paper.event.player.PlayerArmorChangeEvent;
import java.time.Duration;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import me.xginko.aef.AnarchyExploitFixes;
import me.xginko.aef.libs.caffeine.cache.Cache;
import me.xginko.aef.libs.caffeine.cache.Caffeine;
import me.xginko.aef.libs.xseries.XEntityType;
import me.xginko.aef.libs.xseries.XMaterial;
import me.xginko.aef.modules.AEFModule;
import me.xginko.aef.utils.ChunkUtil;
import me.xginko.aef.utils.EntityUtil;
import me.xginko.aef.utils.ItemUtil;
import me.xginko.aef.utils.MaterialUtil;
import me.xginko.aef.utils.WorldUtil;
import me.xginko.aef.utils.enums.IllegalHandling;
import me.xginko.aef.utils.enums.ItemLegality;
import me.xginko.aef.utils.models.ExpiringSet;
import me.xginko.aef.utils.permissions.AEFPermission;
import org.bukkit.Chunk;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.player.PlayerAttemptPickupItemEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jetbrains.annotations.NotNull;

public abstract class IllegalItemModule
extends AEFModule
implements Listener {
    protected final AEFPermission bypassPermission;
    protected final IllegalHandling illegalHandling;
    protected final boolean guiPluginsSupported;
    protected final Set<Listener> optionalListeners;
    private final Duration cooldownDuration;
    private Cache<Class<? extends Event>, ExpiringSet<Object>> listenerCooldowns;

    public IllegalItemModule(String configPath, AEFPermission bypassPermission) {
        this(configPath, false, bypassPermission, null);
    }

    public IllegalItemModule(String configPath, boolean defEnabled, final AEFPermission bypassPermission, String comment) {
        super(configPath, defEnabled, comment);
        IllegalHandling handling;
        this.bypassPermission = bypassPermission;
        this.optionalListeners = new HashSet<Listener>(6);
        String configuredHandling = this.config.getString(configPath + ".handling", IllegalHandling.PREVENT_USE_ONLY.name(), "Available options:\n" + Arrays.stream(IllegalHandling.values()).map(option -> option.name() + " - " + option.description()).collect(Collectors.joining("\n")));
        try {
            handling = IllegalHandling.valueOf(configuredHandling);
        }
        catch (IllegalArgumentException e) {
            handling = IllegalHandling.PREVENT_USE_ONLY;
            this.warn("Handling option '" + configuredHandling + "' not recognized. Defaulting to " + handling.name());
        }
        this.illegalHandling = handling;
        this.guiPluginsSupported = this.config.getBoolean(configPath + ".gui-plugins-supported", false, "Enable this if you have problems with the plugin removing items from chest guis.");
        if (this.illegalHandling == IllegalHandling.STRICT) {
            this.optionalListeners.add(new Listener(){

                @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=false)
                private void onInventoryOpen(InventoryOpenEvent event) {
                    if (AnarchyExploitFixes.permissions().permissionValue((Permissible)event.getPlayer(), bypassPermission.node()).toBoolean()) {
                        return;
                    }
                    if (!IllegalItemModule.this.guiPluginsSupported || event.getInventory().getLocation() != null) {
                        for (ItemStack invItem : event.getInventory()) {
                            IllegalItemModule.this.handleItem(invItem, IllegalItemModule.this.legalityOf(invItem));
                        }
                    }
                }
            });
        }
        if (this.config.getBoolean(configPath + ".prevent-hopper32k-mechanic", false, "Prevents Hopper32k mechanic of placing a shulker containing illegals on top\nof a hopper, then using the illegal out of the hopper's inventory.\nNo longer hooks into InventoryMoveItemEvent and is therefore way less laggy.") && this.illegalHandling != IllegalHandling.ACTION_ON_USE) {
            this.optionalListeners.add(new Listener(){

                @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
                private void onPlayerItemHeld(PlayerItemHeldEvent event) {
                    if (IllegalItemModule.this.isCoolingDown((Event)event, event.getPlayer().getUniqueId())) {
                        event.setCancelled(true);
                        return;
                    }
                    if (AnarchyExploitFixes.permissions().permissionValue((Permissible)event.getPlayer(), bypassPermission.node()).toBoolean()) {
                        return;
                    }
                    if (IllegalItemModule.this.legalityOf(event.getPlayer().getInventory().getItem(event.getNewSlot())) != ItemLegality.LEGAL || IllegalItemModule.this.legalityOf(event.getPlayer().getInventory().getItem(event.getPreviousSlot())) != ItemLegality.LEGAL) {
                        event.setCancelled(true);
                        IllegalItemModule.this.setCoolingDown((Event)event, event.getPlayer().getUniqueId());
                    }
                }
            });
        }
        boolean checkOnChunkload = this.config.getBoolean(configPath + ".check-on-chunkload.enable", false, "WARNING: CHECKING ON CHUNKLOAD IS NOT RECOMMENDED AS IT IS VERY RESOURCE INTENSE.\nBE VERY SURE YOU ACTUALLY NEED THIS.\nIterates over all blocks in a chunk when it is loaded and checks any inventories\nfor illegals. If a container with illegals is found, the container will be REMOVED.");
        final boolean removeContainers = this.config.getBoolean(configPath + ".check-on-chunkload.remove-container", false, "If set to true, immediately replaces the container with air. Otherwise, will try\nto handle items separately.");
        if (checkOnChunkload) {
            this.optionalListeners.add(new Listener(){

                @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=false)
                private void onChunkLoad(ChunkLoadEvent event) {
                    if (event.isNewChunk()) {
                        return;
                    }
                    Chunk chunk = event.getChunk();
                    if (ChunkUtil.isRetrievalUnsafe(chunk)) {
                        return;
                    }
                    int minY = WorldUtil.getMinWorldHeight(event.getWorld());
                    int maxY = event.getWorld().getMaxHeight();
                    for (int x = 0; x < 16; ++x) {
                        for (int z = 0; z < 16; ++z) {
                            for (int y = minY; y < maxY; ++y) {
                                Block block = chunk.getBlock(x, y, z);
                                if (!MaterialUtil.INVENTORY_HOLDERS.get().contains(block.getType())) continue;
                                if (removeContainers) {
                                    if (IllegalItemModule.this.legalityOf((Iterable<ItemStack>)((InventoryHolder)block.getState(false)).getInventory()) == ItemLegality.LEGAL) continue;
                                    block.setType(XMaterial.AIR.get(), false);
                                    continue;
                                }
                                BlockState blockState = block.getState(false);
                                for (ItemStack itemStack : ((InventoryHolder)blockState).getInventory()) {
                                    IllegalItemModule.this.handleItem(itemStack, IllegalItemModule.this.legalityOf(itemStack));
                                }
                                blockState.update(true, false);
                            }
                        }
                    }
                }
            });
        }
        this.cooldownDuration = Duration.ofMillis(this.config.getInt(configPath + ".check-rate-limit-millis", 3000, "The time in milliseconds to wait before performing another check,\nif a check was positive. Helps with lag resulting from repeatedly\nchecking illegals."));
    }

    @NotNull
    public abstract ItemLegality legalityOf(@Nullable ItemStack var1);

    public abstract void handleItem(ItemStack var1, ItemLegality var2);

    @Override
    public void enable() {
        this.listenerCooldowns = Caffeine.newBuilder().expireAfterWrite(Duration.ofMinutes(30L)).evictionListener((eventClass, expiringSet, cause) -> {
            if (expiringSet != null) {
                expiringSet.clear();
                expiringSet.cleanUp();
            }
        }).build();
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
        this.optionalListeners.forEach(optional -> this.plugin.getServer().getPluginManager().registerEvents(optional, (Plugin)this.plugin));
    }

    @Override
    public void disable() {
        HandlerList.unregisterAll((Listener)this);
        this.optionalListeners.forEach(HandlerList::unregisterAll);
        this.optionalListeners.clear();
        if (this.listenerCooldowns != null) {
            this.listenerCooldowns.invalidateAll();
            this.listenerCooldowns.cleanUp();
            this.listenerCooldowns = null;
        }
    }

    public ItemLegality legalityOf(Iterable<ItemStack> itemStacks) {
        if (itemStacks == null) {
            return ItemLegality.LEGAL;
        }
        for (ItemStack itemStack : itemStacks) {
            if (this.legalityOf(itemStack) == ItemLegality.LEGAL) continue;
            return ItemLegality.CONTAINS_ILLEGAL;
        }
        return ItemLegality.LEGAL;
    }

    protected boolean isCoolingDown(Event event, Object identifier) {
        return this.listenerCooldowns.get(event.getClass(), eventClass -> new ExpiringSet(this.cooldownDuration)).contains(identifier);
    }

    protected boolean setCoolingDown(Event event, Object identifier) {
        return this.listenerCooldowns.get(event.getClass(), eventClass -> new ExpiringSet(this.cooldownDuration)).add(identifier);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=false)
    public void onPlayerItemConsume(PlayerItemConsumeEvent event) {
        if (event.isCancelled() && this.illegalHandling == IllegalHandling.PREVENT_USE_ONLY) {
            return;
        }
        if (AnarchyExploitFixes.permissions().permissionValue((Permissible)event.getPlayer(), this.bypassPermission.node()).toBoolean()) {
            return;
        }
        ItemStack consumable = event.getItem();
        ItemLegality legality = this.legalityOf(consumable);
        if (legality != ItemLegality.LEGAL) {
            event.setCancelled(true);
            this.handleItem(consumable, legality);
            event.setReplacement(consumable);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=false)
    public void onBlockDispense(BlockDispenseEvent event) {
        if (event.isCancelled() && this.illegalHandling == IllegalHandling.PREVENT_USE_ONLY) {
            return;
        }
        if (this.isCoolingDown((Event)event, event.getBlock().getLocation())) {
            event.setCancelled(true);
            return;
        }
        if (this.legalityOf(event.getItem()) != ItemLegality.LEGAL) {
            event.setCancelled(true);
            this.setCoolingDown((Event)event, event.getBlock().getLocation());
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=false)
    public void onPlayerArmorChange(PlayerArmorChangeEvent event) {
        if (event.getSlotType() == null) {
            return;
        }
        if (AnarchyExploitFixes.permissions().permissionValue((Permissible)event.getPlayer(), this.bypassPermission.node()).toBoolean()) {
            return;
        }
        ItemStack newItem = event.getPlayer().getInventory().getItem(ItemUtil.getEquipmentSlot(event.getSlotType()));
        if (newItem == null || MaterialUtil.AIR.get().contains(newItem.getType())) {
            return;
        }
        ItemLegality legality = this.legalityOf(newItem);
        if (legality != ItemLegality.ILLEGAL) {
            return;
        }
        if (this.illegalHandling != IllegalHandling.PREVENT_USE_ONLY) {
            this.handleItem(newItem, legality);
        }
        event.getPlayer().getWorld().dropItemNaturally(event.getPlayer().getLocation(), newItem);
        event.getPlayer().getInventory().setItem(ItemUtil.getEquipmentSlot(event.getSlotType()), null);
        event.getPlayer().updateInventory();
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=false)
    public void onInventoryClick(InventoryClickEvent event) {
        if (this.guiPluginsSupported && event.getInventory().getLocation() == null) {
            return;
        }
        if (AnarchyExploitFixes.permissions().permissionValue((Permissible)event.getWhoClicked(), this.bypassPermission.node()).toBoolean()) {
            return;
        }
        if (this.isCoolingDown((Event)event, event.getWhoClicked().getUniqueId())) {
            event.setCancelled(true);
            return;
        }
        ItemLegality clickedLegality = this.legalityOf(event.getCurrentItem());
        if (clickedLegality != ItemLegality.LEGAL) {
            if (this.illegalHandling == IllegalHandling.PREVENT_USE_ONLY) {
                if (event.getAction() == InventoryAction.HOTBAR_MOVE_AND_READD || event.getAction() == InventoryAction.HOTBAR_SWAP) {
                    event.setCancelled(true);
                }
            } else {
                ItemStack currentItem = event.getCurrentItem().clone();
                event.setCancelled(true);
                this.handleItem(currentItem, clickedLegality);
                event.setCurrentItem(currentItem);
                this.setCoolingDown((Event)event, event.getWhoClicked().getUniqueId());
            }
        }
        if (this.illegalHandling == IllegalHandling.PREVENT_USE_ONLY) {
            return;
        }
        ItemLegality cursorLegality = this.legalityOf(event.getCursor());
        if (cursorLegality != ItemLegality.LEGAL) {
            event.setCancelled(true);
            this.handleItem(event.getCursor(), cursorLegality);
            this.setCoolingDown((Event)event, event.getWhoClicked().getUniqueId());
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=false)
    public void onInventoryDrag(InventoryDragEvent event) {
        if (this.illegalHandling == IllegalHandling.PREVENT_USE_ONLY) {
            return;
        }
        if (this.guiPluginsSupported && event.getInventory().getLocation() == null) {
            return;
        }
        if (this.isCoolingDown((Event)event, event.getWhoClicked().getUniqueId())) {
            event.setCancelled(true);
            return;
        }
        if (AnarchyExploitFixes.permissions().permissionValue((Permissible)event.getWhoClicked(), this.bypassPermission.node()).toBoolean()) {
            return;
        }
        for (ItemStack invItem : event.getInventory()) {
            ItemLegality invItemLegality = this.legalityOf(invItem);
            if (invItemLegality == ItemLegality.LEGAL) continue;
            event.setCancelled(true);
            this.handleItem(invItem, invItemLegality);
            this.setCoolingDown((Event)event, event.getWhoClicked().getUniqueId());
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=false)
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        if (event.isCancelled() && this.illegalHandling == IllegalHandling.PREVENT_USE_ONLY) {
            return;
        }
        if (event.getDamager().getType() == XEntityType.PLAYER.get()) {
            ItemStack offHandItem;
            ItemLegality offHandLegality;
            Player player = (Player)event.getDamager();
            if (this.isCoolingDown((Event)event, player.getUniqueId())) {
                event.setCancelled(true);
                return;
            }
            if (AnarchyExploitFixes.permissions().permissionValue((Permissible)player, this.bypassPermission.node()).toBoolean()) {
                return;
            }
            ItemStack mainHandItem = player.getInventory().getItemInMainHand();
            ItemLegality mainHandLegality = this.legalityOf(mainHandItem);
            if (mainHandLegality != ItemLegality.LEGAL) {
                event.setCancelled(true);
                this.handleItem(mainHandItem, mainHandLegality);
                this.setCoolingDown((Event)event, player.getUniqueId());
            }
            if ((offHandLegality = this.legalityOf(offHandItem = player.getInventory().getItemInOffHand())) != ItemLegality.LEGAL) {
                event.setCancelled(true);
                this.handleItem(offHandItem, offHandLegality);
                this.setCoolingDown((Event)event, player.getUniqueId());
            }
            return;
        }
        if (EntityUtil.isInventoryHolder(event.getDamager()) && this.legalityOf((Iterable<ItemStack>)((InventoryHolder)event.getDamager()).getInventory()) != ItemLegality.LEGAL) {
            event.setCancelled(true);
            if (this.illegalHandling != IllegalHandling.PREVENT_USE_ONLY) {
                event.getDamager().remove();
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=false)
    public void onPlayerAttemptPickupItem(PlayerAttemptPickupItemEvent event) {
        if (this.illegalHandling == IllegalHandling.PREVENT_USE_ONLY) {
            return;
        }
        if (AnarchyExploitFixes.permissions().permissionValue((Permissible)event.getPlayer(), this.bypassPermission.node()).toBoolean()) {
            return;
        }
        ItemLegality legality = this.legalityOf(event.getItem().getItemStack());
        if (legality != ItemLegality.LEGAL) {
            event.setCancelled(true);
            ItemStack pickUpItem = event.getItem().getItemStack().clone();
            this.handleItem(pickUpItem, legality);
            event.getItem().setItemStack(pickUpItem);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=false)
    public void onPlayerDropItem(PlayerDropItemEvent event) {
        if (this.illegalHandling == IllegalHandling.PREVENT_USE_ONLY) {
            return;
        }
        if (AnarchyExploitFixes.permissions().permissionValue((Permissible)event.getPlayer(), this.bypassPermission.node()).toBoolean()) {
            return;
        }
        ItemLegality legality = this.legalityOf(event.getItemDrop().getItemStack());
        if (legality != ItemLegality.LEGAL) {
            ItemStack droppedItem = event.getItemDrop().getItemStack().clone();
            this.handleItem(droppedItem, legality);
            event.getItemDrop().setItemStack(droppedItem);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=false)
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.useItemInHand() == Event.Result.DENY && this.illegalHandling == IllegalHandling.PREVENT_USE_ONLY) {
            return;
        }
        if (this.isCoolingDown((Event)event, event.getPlayer().getUniqueId())) {
            event.setCancelled(true);
            return;
        }
        if (AnarchyExploitFixes.permissions().permissionValue((Permissible)event.getPlayer(), this.bypassPermission.node()).toBoolean()) {
            return;
        }
        ItemStack interactItem = event.getItem();
        ItemLegality legality = this.legalityOf(interactItem);
        if (legality != ItemLegality.LEGAL) {
            event.setCancelled(true);
            this.handleItem(interactItem, legality);
            this.setCoolingDown((Event)event, event.getPlayer().getUniqueId());
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=false)
    public void onPlayerInteractEntity(PlayerInteractEntityEvent event) {
        if (event.isCancelled() && this.illegalHandling == IllegalHandling.PREVENT_USE_ONLY) {
            return;
        }
        if (this.isCoolingDown((Event)event, event.getPlayer().getUniqueId())) {
            event.setCancelled(true);
            return;
        }
        if (AnarchyExploitFixes.permissions().permissionValue((Permissible)event.getPlayer(), this.bypassPermission.node()).toBoolean()) {
            return;
        }
        ItemStack handItem = event.getPlayer().getInventory().getItem(event.getHand());
        ItemLegality legality = this.legalityOf(handItem);
        if (legality != ItemLegality.LEGAL) {
            event.setCancelled(true);
            this.handleItem(handItem, legality);
            this.setCoolingDown((Event)event, event.getPlayer().getUniqueId());
        }
    }
}

