/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.illegals.items;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import me.xginko.aef.libs.xseries.XMaterial;
import me.xginko.aef.modules.illegals.items.IllegalItemModule;
import me.xginko.aef.utils.ItemUtil;
import me.xginko.aef.utils.MaterialUtil;
import me.xginko.aef.utils.enums.IllegalHandling;
import me.xginko.aef.utils.enums.ItemLegality;
import me.xginko.aef.utils.permissions.AEFPermission;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jetbrains.annotations.NotNull;

public class InvalidStackSize
extends IllegalItemModule {
    private final Set<Material> whitelistedTypes;
    private final boolean useWhitelist;
    private final boolean blacklistMode;
    private final boolean checkStored;

    public InvalidStackSize() {
        super("illegals.illegally-stacked-items", false, AEFPermission.BYPASS_ILLEGAL_OVERSTACKED, "Bypass permission: " + AEFPermission.BYPASS_ILLEGAL_OVERSTACKED.node() + "\nPrevents usage of or reverts items with a higher or lower\nstack size than their vanilla limit.");
        this.useWhitelist = this.config.getBoolean(this.configPath + ".item-whitelist-enabled", false);
        this.blacklistMode = this.config.getBoolean(this.configPath + ".use-as-blacklist-instead", true);
        this.checkStored = this.config.getBoolean(this.configPath + ".check-stored-items", false);
        this.whitelistedTypes = this.config.getList(this.configPath + ".whitelisted-items", Collections.singletonList(XMaterial.TOTEM_OF_UNDYING.get().name())).stream().map(configuredType -> {
            try {
                return Material.valueOf((String)configuredType);
            }
            catch (IllegalArgumentException e) {
                this.notRecognized(Material.class, (String)configuredType);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toCollection(() -> EnumSet.noneOf(Material.class)));
    }

    @Override
    @NotNull
    public ItemLegality legalityOf(@Nullable ItemStack itemStack) {
        if (itemStack == null || MaterialUtil.AIR.get().contains(itemStack.getType())) {
            return ItemLegality.LEGAL;
        }
        if (!(this.useWhitelist && this.blacklistMode != this.whitelistedTypes.contains(itemStack.getType()) || itemStack.getAmount() <= itemStack.getMaxStackSize() && itemStack.getAmount() >= 1)) {
            return ItemLegality.ILLEGAL;
        }
        if (this.checkStored) {
            return this.legalityOf(ItemUtil.getStoredItems(itemStack));
        }
        return ItemLegality.LEGAL;
    }

    @Override
    public void handleItem(ItemStack itemStack, ItemLegality legality) {
        if (this.illegalHandling == IllegalHandling.PREVENT_USE_ONLY) {
            return;
        }
        switch (legality) {
            case ILLEGAL: {
                if (itemStack.getAmount() < 1) {
                    itemStack.setAmount(1);
                    return;
                }
                if (itemStack.getAmount() > itemStack.getMaxStackSize()) {
                    itemStack.setAmount(itemStack.getMaxStackSize());
                }
                return;
            }
            case CONTAINS_ILLEGAL: {
                itemStack.setAmount(0);
            }
        }
    }
}

