/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.illegals.items;

import me.xginko.aef.modules.illegals.items.IllegalItemModule;
import me.xginko.aef.utils.ItemUtil;
import me.xginko.aef.utils.MaterialUtil;
import me.xginko.aef.utils.enums.IllegalHandling;
import me.xginko.aef.utils.enums.ItemLegality;
import me.xginko.aef.utils.permissions.AEFPermission;
import org.bukkit.inventory.ItemStack;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jetbrains.annotations.NotNull;

public class PlayerHeads
extends IllegalItemModule {
    private final boolean checkStored;

    public PlayerHeads() {
        super("illegals.ban-player-heads", false, AEFPermission.BYPASS_ILLEGAL_PLAYERHEAD, "Bypass permission: " + AEFPermission.BYPASS_ILLEGAL_PLAYERHEAD.node() + "\nDeletes or prevents usage of player heads.");
        this.checkStored = this.config.getBoolean(this.configPath + ".check-stored-items", false, "Will delete shulker/bundle if they contain any player heads.");
    }

    @Override
    @NotNull
    public ItemLegality legalityOf(@Nullable ItemStack itemStack) {
        if (itemStack == null) {
            return ItemLegality.LEGAL;
        }
        if (MaterialUtil.isPlayerHead(itemStack)) {
            return ItemLegality.ILLEGAL;
        }
        if (this.checkStored) {
            return this.legalityOf(ItemUtil.getStoredItems(itemStack));
        }
        return ItemLegality.LEGAL;
    }

    @Override
    public void handleItem(ItemStack itemStack, ItemLegality legality) {
        if (this.illegalHandling == IllegalHandling.PREVENT_USE_ONLY) {
            return;
        }
        if (legality != ItemLegality.LEGAL) {
            itemStack.setAmount(0);
        }
    }
}

