/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.illegals.items.datavalues;

import com.github.retrooper.packetevents.manager.server.ServerVersion;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import me.xginko.aef.modules.illegals.items.IllegalItemModule;
import me.xginko.aef.utils.ItemUtil;
import me.xginko.aef.utils.MaterialUtil;
import me.xginko.aef.utils.enums.IllegalHandling;
import me.xginko.aef.utils.enums.ItemLegality;
import me.xginko.aef.utils.enums.Platform;
import me.xginko.aef.utils.permissions.AEFPermission;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jetbrains.annotations.NotNull;

public class CustomDataValues
extends IllegalItemModule {
    private final Set<Material> whitelistedTypes;
    private final Set<String> forbiddenDataValues;
    private final boolean useWhitelist;
    private final boolean blacklistMode;
    private final boolean checkStored;

    public CustomDataValues() {
        super("illegals.data-values.custom-data-values", false, AEFPermission.BYPASS_ILLEGAL_DATA_CUSTOM, "1.12 Only. Bypass permission: " + AEFPermission.BYPASS_ILLEGAL_DATA_CUSTOM.node() + "\nDeletes items with configured illegal MaterialData values.\nUse '/aef datavalue' ingame while holding an item to add the\nspecific value here.");
        this.checkStored = this.config.getBoolean(this.configPath + ".check-stored-items", false);
        this.forbiddenDataValues = new HashSet<String>(this.config.getList(this.configPath + ".data-values", Collections.singletonList("SuperIllegalItem(0)")));
        this.useWhitelist = this.config.getBoolean(this.configPath + ".item-whitelist-enabled", false);
        this.blacklistMode = this.config.getBoolean(this.configPath + ".use-as-blacklist-instead", false);
        this.whitelistedTypes = this.config.getList(this.configPath + ".whitelisted-items", Collections.singletonList("GOLDEN_APPLE")).stream().map(configuredItem -> {
            try {
                return Material.valueOf((String)configuredItem);
            }
            catch (IllegalArgumentException e) {
                this.notRecognized(Material.class, (String)configuredItem);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toCollection(() -> EnumSet.noneOf(Material.class)));
    }

    @Override
    public boolean shouldEnable() {
        return this.configEnabled && Platform.getServerVersion().isOlderThanOrEquals(ServerVersion.V_1_12_2);
    }

    @Override
    @NotNull
    public ItemLegality legalityOf(@Nullable ItemStack itemStack) {
        if (itemStack == null || MaterialUtil.AIR.get().contains(itemStack.getType())) {
            return ItemLegality.LEGAL;
        }
        if ((!this.useWhitelist || this.blacklistMode == this.whitelistedTypes.contains(itemStack.getType())) && this.forbiddenDataValues.contains(itemStack.getData().toString())) {
            return ItemLegality.ILLEGAL;
        }
        if (this.checkStored) {
            return this.legalityOf(ItemUtil.getStoredItems(itemStack));
        }
        return ItemLegality.LEGAL;
    }

    @Override
    public void handleItem(ItemStack itemStack, ItemLegality legality) {
        if (this.illegalHandling == IllegalHandling.PREVENT_USE_ONLY) {
            return;
        }
        if (legality != ItemLegality.LEGAL) {
            itemStack.setAmount(0);
        }
    }
}

