/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.illegals.items.datavalues;

import com.github.retrooper.packetevents.manager.server.ServerVersion;
import java.util.EnumMap;
import java.util.Map;
import me.xginko.aef.libs.xseries.XMaterial;
import me.xginko.aef.modules.illegals.items.IllegalItemModule;
import me.xginko.aef.utils.ItemUtil;
import me.xginko.aef.utils.enums.IllegalHandling;
import me.xginko.aef.utils.enums.ItemLegality;
import me.xginko.aef.utils.enums.Platform;
import me.xginko.aef.utils.permissions.AEFPermission;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.MaterialData;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jetbrains.annotations.NotNull;

public class IllegalGoldenApples
extends IllegalItemModule {
    private final Map<Material, MaterialData> allowedAppleData = new EnumMap<Material, MaterialData>(Material.class);
    private final boolean checkStored = this.config.getBoolean(this.configPath + ".check-stored-items", false);

    public IllegalGoldenApples() {
        super("illegals.data-values.illegal-golden-apples", false, AEFPermission.BYPASS_ILLEGAL_DATA_APPLE, "1.12 Only. Bypass permission: " + AEFPermission.BYPASS_ILLEGAL_DATA_APPLE.node() + "\nDeletes apples with illegal MaterialData values. Will use the\nAPI to determine what a natural value looks like.");
        if (XMaterial.GOLDEN_APPLE.isSupported()) {
            this.allowedAppleData.put(XMaterial.GOLDEN_APPLE.get(), new MaterialData(XMaterial.GOLDEN_APPLE.get()));
        }
        if (XMaterial.ENCHANTED_GOLDEN_APPLE.isSupported()) {
            this.allowedAppleData.put(XMaterial.ENCHANTED_GOLDEN_APPLE.get(), new MaterialData(XMaterial.ENCHANTED_GOLDEN_APPLE.get()));
        }
    }

    @Override
    public boolean shouldEnable() {
        return this.configEnabled && Platform.getServerVersion().isOlderThanOrEquals(ServerVersion.V_1_12_2);
    }

    @Override
    @NotNull
    public ItemLegality legalityOf(@Nullable ItemStack itemStack) {
        if (itemStack == null) {
            return ItemLegality.LEGAL;
        }
        if (this.allowedAppleData.containsKey(itemStack.getType()) && !this.allowedAppleData.containsValue(itemStack.getData())) {
            return ItemLegality.ILLEGAL;
        }
        if (this.checkStored) {
            return this.legalityOf(ItemUtil.getStoredItems(itemStack));
        }
        return ItemLegality.LEGAL;
    }

    @Override
    public void handleItem(ItemStack itemStack, ItemLegality legality) {
        if (this.illegalHandling == IllegalHandling.PREVENT_USE_ONLY) {
            return;
        }
        switch (legality) {
            case ILLEGAL: {
                itemStack.setData(this.allowedAppleData.get(itemStack.getType()));
                break;
            }
            case CONTAINS_ILLEGAL: {
                itemStack.setAmount(0);
            }
        }
    }
}

