/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.illegals.items.enchantments;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import me.xginko.aef.libs.xseries.XEnchantment;
import me.xginko.aef.libs.xseries.XMaterial;
import me.xginko.aef.modules.illegals.items.IllegalItemModule;
import me.xginko.aef.utils.ItemUtil;
import me.xginko.aef.utils.MaterialUtil;
import me.xginko.aef.utils.enums.IllegalHandling;
import me.xginko.aef.utils.enums.ItemLegality;
import me.xginko.aef.utils.permissions.AEFPermission;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jetbrains.annotations.NotNull;

public class HigherEnchants
extends IllegalItemModule {
    private final Set<Enchantment> specificEnchants;
    private final Set<Material> whitelistedTypes;
    private final boolean useWhitelist;
    private final boolean blacklistMode;
    private final boolean checkStored;
    private final boolean onlySomeEnchants;

    public HigherEnchants() {
        super("illegals.enchantments.higher-enchants", false, AEFPermission.BYPASS_ILLEGAL_ENCHANT_HIGHER, "Bypass permission: " + AEFPermission.BYPASS_ILLEGAL_ENCHANT_HIGHER.node() + "\nReverts or prevents usage of ItemStacks with Enchantments higher\nthan the natural, in vanilla survival obtainable level (aka 32ks / 255s).");
        this.checkStored = this.config.getBoolean(this.configPath + ".check-stored-items", false);
        this.onlySomeEnchants = this.config.getBoolean(this.configPath + ".only-specific-enchants", false);
        this.specificEnchants = this.config.getList(this.configPath + ".specific-enchants", Collections.singletonList(((Enchantment)XEnchantment.EFFICIENCY.get()).getName())).stream().map(configuredEnchant -> {
            Optional<XEnchantment> enchantment = XEnchantment.of(configuredEnchant);
            if (!enchantment.isPresent()) {
                this.notRecognized(Enchantment.class, (String)configuredEnchant);
                return null;
            }
            return (Enchantment)enchantment.get().get();
        }).filter(Objects::nonNull).collect(Collectors.toCollection(HashSet::new));
        this.useWhitelist = this.config.getBoolean(this.configPath + ".item-whitelist-enabled", true);
        this.blacklistMode = this.config.getBoolean(this.configPath + ".use-as-blacklist-instead", false);
        this.whitelistedTypes = this.config.getList(this.configPath + ".whitelisted-items", Collections.singletonList(XMaterial.GOLDEN_APPLE.get().name())).stream().map(configuredType -> {
            try {
                return Material.valueOf((String)configuredType);
            }
            catch (IllegalArgumentException e) {
                this.notRecognized(Material.class, (String)configuredType);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toCollection(() -> EnumSet.noneOf(Material.class)));
    }

    @Override
    @NotNull
    public ItemLegality legalityOf(@Nullable ItemStack itemStack) {
        if (itemStack == null || MaterialUtil.AIR.get().contains(itemStack.getType())) {
            return ItemLegality.LEGAL;
        }
        if (!this.useWhitelist || this.blacklistMode == this.whitelistedTypes.contains(itemStack.getType())) {
            for (Map.Entry enchant : itemStack.getEnchantments().entrySet()) {
                if (this.onlySomeEnchants && !this.specificEnchants.contains(enchant.getKey()) || (Integer)enchant.getValue() <= ((Enchantment)enchant.getKey()).getMaxLevel()) continue;
                return ItemLegality.ILLEGAL;
            }
        }
        if (this.checkStored) {
            return this.legalityOf(ItemUtil.getStoredItems(itemStack));
        }
        return ItemLegality.LEGAL;
    }

    @Override
    public void handleItem(ItemStack itemStack, ItemLegality legality) {
        if (legality == ItemLegality.LEGAL) {
            return;
        }
        if (this.illegalHandling == IllegalHandling.PREVENT_USE_ONLY) {
            return;
        }
        if (legality == ItemLegality.CONTAINS_ILLEGAL) {
            itemStack.setAmount(0);
            return;
        }
        for (Map.Entry enchant : itemStack.getEnchantments().entrySet()) {
            if ((Integer)enchant.getValue() <= ((Enchantment)enchant.getKey()).getMaxLevel()) continue;
            itemStack.removeEnchantment((Enchantment)enchant.getKey());
            itemStack.addUnsafeEnchantment((Enchantment)enchant.getKey(), ((Enchantment)enchant.getKey()).getMaxLevel());
        }
    }
}

