/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.illegals.items.enchantments;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import me.xginko.aef.libs.xseries.XMaterial;
import me.xginko.aef.modules.illegals.items.IllegalItemModule;
import me.xginko.aef.utils.ItemUtil;
import me.xginko.aef.utils.MaterialUtil;
import me.xginko.aef.utils.enums.IllegalHandling;
import me.xginko.aef.utils.enums.ItemLegality;
import me.xginko.aef.utils.permissions.AEFPermission;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jetbrains.annotations.NotNull;

public class InapplicableEnchants
extends IllegalItemModule {
    private final Set<Material> whitelistedTypes;
    private final boolean useWhitelist;
    private final boolean blacklistMode;
    private final boolean checkStored;

    public InapplicableEnchants() {
        super("illegals.enchantments.inapplicable-enchants", false, AEFPermission.BYPASS_ILLEGAL_ENCHANT_INAPPLICABLE, "Bypass permission: " + AEFPermission.BYPASS_ILLEGAL_ENCHANT_INAPPLICABLE.node() + "\nReverts or prevents usage of ItemStacks with Enchantments that\ncannot be applied to that ItemStack in vanilla survival minecraft.\nExamples: A helmet with sharpness or a block of stone with fortune.");
        this.checkStored = this.config.getBoolean(this.configPath + ".check-stored-items", false);
        this.useWhitelist = this.config.getBoolean(this.configPath + ".item-whitelist-enabled", true);
        this.blacklistMode = this.config.getBoolean(this.configPath + ".use-as-blacklist-instead", false);
        this.whitelistedTypes = this.config.getList(this.configPath + ".whitelisted-items", Collections.singletonList(XMaterial.GOLDEN_APPLE.get().name())).stream().map(configuredType -> {
            try {
                return Material.valueOf((String)configuredType);
            }
            catch (IllegalArgumentException e) {
                this.notRecognized(Material.class, (String)configuredType);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toCollection(() -> EnumSet.noneOf(Material.class)));
    }

    @Override
    @NotNull
    public ItemLegality legalityOf(@Nullable ItemStack itemStack) {
        if (itemStack == null || MaterialUtil.AIR.get().contains(itemStack.getType())) {
            return ItemLegality.LEGAL;
        }
        if (!this.useWhitelist || this.blacklistMode == this.whitelistedTypes.contains(itemStack.getType())) {
            for (Map.Entry enchant : itemStack.getEnchantments().entrySet()) {
                if (((Enchantment)enchant.getKey()).canEnchantItem(itemStack)) continue;
                return ItemLegality.ILLEGAL;
            }
        }
        if (this.checkStored) {
            return this.legalityOf(ItemUtil.getStoredItems(itemStack));
        }
        return ItemLegality.LEGAL;
    }

    @Override
    public void handleItem(ItemStack itemStack, ItemLegality legality) {
        if (legality == ItemLegality.LEGAL) {
            return;
        }
        if (this.illegalHandling == IllegalHandling.PREVENT_USE_ONLY) {
            return;
        }
        if (legality == ItemLegality.CONTAINS_ILLEGAL) {
            itemStack.setAmount(0);
            return;
        }
        for (Map.Entry enchant : itemStack.getEnchantments().entrySet()) {
            if (((Enchantment)enchant.getKey()).canEnchantItem(itemStack)) continue;
            itemStack.removeEnchantment((Enchantment)enchant.getKey());
        }
    }
}

