/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.illegals.items.enchantments;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import me.xginko.aef.libs.xseries.XEnchantment;
import me.xginko.aef.libs.xseries.XMaterial;
import me.xginko.aef.modules.illegals.items.IllegalItemModule;
import me.xginko.aef.utils.ItemUtil;
import me.xginko.aef.utils.MaterialUtil;
import me.xginko.aef.utils.enums.IllegalHandling;
import me.xginko.aef.utils.enums.ItemLegality;
import me.xginko.aef.utils.permissions.AEFPermission;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jetbrains.annotations.NotNull;

public class IncompatibleEnchants
extends IllegalItemModule {
    private final Set<Material> whitelistedTypes;
    private final Enchantment[] damageEnchants = new Enchantment[]{(Enchantment)XEnchantment.SHARPNESS.get(), (Enchantment)XEnchantment.SMITE.get(), (Enchantment)XEnchantment.BANE_OF_ARTHROPODS.get()};
    private final Enchantment[] protectionEnchants = new Enchantment[]{(Enchantment)XEnchantment.PROTECTION.get(), (Enchantment)XEnchantment.BLAST_PROTECTION.get(), (Enchantment)XEnchantment.FIRE_PROTECTION.get(), (Enchantment)XEnchantment.PROJECTILE_PROTECTION.get()};
    private final boolean useWhitelist;
    private final boolean blacklistMode;
    private final boolean checkStored = this.config.getBoolean(this.configPath + ".check-stored-items", false);

    public IncompatibleEnchants() {
        super("illegals.enchantments.incompatible-enchants", false, AEFPermission.BYPASS_ILLEGAL_ENCHANT_INCOMPATIBLE, "Bypass permission: " + AEFPermission.BYPASS_ILLEGAL_ENCHANT_INCOMPATIBLE.node() + "\nReverts or prevents usage of ItemStacks with Enchantments that\ncannot coexist in vanilla survival minecraft.\nExamples: A bow with mending and infinity or armor with every\nprotection enchantment.");
        this.useWhitelist = this.config.getBoolean(this.configPath + ".item-whitelist-enabled", true);
        this.blacklistMode = this.config.getBoolean(this.configPath + ".use-as-blacklist-instead", false);
        this.whitelistedTypes = this.config.getList(this.configPath + ".whitelisted-items", Collections.singletonList(XMaterial.BOW.get().name())).stream().map(configuredType -> {
            try {
                return Material.valueOf((String)configuredType);
            }
            catch (IllegalArgumentException e) {
                this.notRecognized(Material.class, (String)configuredType);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toCollection(() -> EnumSet.noneOf(Material.class)));
    }

    @Override
    @NotNull
    public ItemLegality legalityOf(@Nullable ItemStack itemStack) {
        Set enchantments;
        if (itemStack == null || MaterialUtil.AIR.get().contains(itemStack.getType())) {
            return ItemLegality.LEGAL;
        }
        if (!(this.useWhitelist && this.blacklistMode != this.whitelistedTypes.contains(itemStack.getType()) || (enchantments = itemStack.getEnchantments().keySet()).isEmpty())) {
            if (enchantments.contains(XEnchantment.SILK_TOUCH.get()) && enchantments.contains(XEnchantment.FORTUNE.get())) {
                return ItemLegality.ILLEGAL;
            }
            if (enchantments.contains(XEnchantment.DEPTH_STRIDER.get()) && enchantments.contains(XEnchantment.FROST_WALKER.get())) {
                return ItemLegality.ILLEGAL;
            }
            if (enchantments.contains(XEnchantment.INFINITY.get()) && enchantments.contains(XEnchantment.MENDING.get())) {
                return ItemLegality.ILLEGAL;
            }
            if (enchantments.contains(XEnchantment.BINDING_CURSE.get()) && enchantments.contains(XEnchantment.VANISHING_CURSE.get())) {
                return ItemLegality.ILLEGAL;
            }
            if (XEnchantment.RIPTIDE.isSupported() && enchantments.contains(XEnchantment.RIPTIDE.get()) && (enchantments.contains(XEnchantment.LOYALTY.get()) || enchantments.contains(XEnchantment.CHANNELING.get()))) {
                return ItemLegality.ILLEGAL;
            }
            if (XEnchantment.MULTISHOT.isSupported() && enchantments.contains(XEnchantment.MULTISHOT.get()) && enchantments.contains(XEnchantment.PIERCING.get())) {
                return ItemLegality.ILLEGAL;
            }
            int dmgEnchCount = 0;
            for (Enchantment damageEnchant : this.damageEnchants) {
                if (!enchantments.contains(damageEnchant) || ++dmgEnchCount <= 1) continue;
                return ItemLegality.ILLEGAL;
            }
            int protEnchCount = 0;
            for (Enchantment protectEnchant : this.protectionEnchants) {
                if (!enchantments.contains(protectEnchant) || ++protEnchCount <= 1) continue;
                return ItemLegality.ILLEGAL;
            }
        }
        if (this.checkStored) {
            return this.legalityOf(ItemUtil.getStoredItems(itemStack));
        }
        return ItemLegality.LEGAL;
    }

    @Override
    public void handleItem(ItemStack itemStack, ItemLegality legality) {
        if (legality == ItemLegality.LEGAL) {
            return;
        }
        if (this.illegalHandling == IllegalHandling.PREVENT_USE_ONLY) {
            return;
        }
        if (legality == ItemLegality.CONTAINS_ILLEGAL) {
            itemStack.setAmount(0);
            return;
        }
        Set enchantments = itemStack.getEnchantments().keySet();
        if (enchantments.contains(XEnchantment.SILK_TOUCH.get()) && enchantments.contains(XEnchantment.FORTUNE.get())) {
            itemStack.removeEnchantment((Enchantment)XEnchantment.FORTUNE.get());
        }
        if (enchantments.contains(XEnchantment.DEPTH_STRIDER.get()) && enchantments.contains(XEnchantment.FROST_WALKER.get())) {
            itemStack.removeEnchantment((Enchantment)XEnchantment.FROST_WALKER.get());
        }
        if (enchantments.contains(XEnchantment.INFINITY.get()) && enchantments.contains(XEnchantment.MENDING.get())) {
            itemStack.removeEnchantment((Enchantment)XEnchantment.INFINITY.get());
        }
        if (enchantments.contains(XEnchantment.BINDING_CURSE.get()) && enchantments.contains(XEnchantment.VANISHING_CURSE.get())) {
            itemStack.removeEnchantment((Enchantment)XEnchantment.BINDING_CURSE.get());
        }
        if (XEnchantment.RIPTIDE.isSupported() && enchantments.contains(XEnchantment.RIPTIDE.get()) && (enchantments.contains(XEnchantment.LOYALTY.get()) || enchantments.contains(XEnchantment.CHANNELING.get()))) {
            itemStack.removeEnchantment((Enchantment)XEnchantment.RIPTIDE.get());
        }
        if (XEnchantment.MULTISHOT.isSupported() && enchantments.contains(XEnchantment.MULTISHOT.get()) && enchantments.contains(XEnchantment.PIERCING.get())) {
            itemStack.removeEnchantment((Enchantment)XEnchantment.MULTISHOT.get());
        }
        if (enchantments.contains(XEnchantment.SHARPNESS.get())) {
            for (Enchantment dmgEnchant : this.damageEnchants) {
                if (dmgEnchant == XEnchantment.SHARPNESS.get()) continue;
                itemStack.removeEnchantment(dmgEnchant);
            }
        } else if (enchantments.contains(XEnchantment.BANE_OF_ARTHROPODS.get()) && enchantments.contains(XEnchantment.SMITE.get())) {
            itemStack.removeEnchantment((Enchantment)XEnchantment.BANE_OF_ARTHROPODS.get());
        }
        if (enchantments.contains(XEnchantment.PROTECTION.get())) {
            for (Enchantment protEnchant : this.protectionEnchants) {
                if (protEnchant == XEnchantment.PROTECTION.get()) continue;
                itemStack.removeEnchantment(protEnchant);
            }
        } else if (enchantments.contains(XEnchantment.BLAST_PROTECTION.get())) {
            for (Enchantment protEnchant : this.protectionEnchants) {
                if (protEnchant == XEnchantment.BLAST_PROTECTION.get()) continue;
                itemStack.removeEnchantment(protEnchant);
            }
        } else if (enchantments.contains(XEnchantment.PROJECTILE_PROTECTION.get()) && enchantments.contains(XEnchantment.FIRE_PROTECTION.get())) {
            itemStack.removeEnchantment((Enchantment)XEnchantment.FIRE_PROTECTION.get());
        }
    }
}

