/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.illegals.items.nbt;

import me.xginko.aef.modules.illegals.items.IllegalItemModule;
import me.xginko.aef.utils.ItemUtil;
import me.xginko.aef.utils.MaterialUtil;
import me.xginko.aef.utils.enums.ItemLegality;
import me.xginko.aef.utils.permissions.AEFPermission;
import org.bukkit.inventory.ItemStack;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jetbrains.annotations.NotNull;

public class CommandItems
extends IllegalItemModule {
    private final boolean checkStored;

    public CommandItems() {
        super("illegals.nbt.command-items", false, AEFPermission.BYPASS_ILLEGAL_NBT_COMMAND_ITEM, "Bypass permission: " + AEFPermission.BYPASS_ILLEGAL_NBT_COMMAND_ITEM.node() + "\nDeletes items with commands in their NBT data that run as operator.\nThese can only be created by players with creative access.\nMost common items are books, since it allows storing multiple commands.");
        this.checkStored = this.config.getBoolean(this.configPath + ".check-stored-items", false);
    }

    @Override
    @NotNull
    public ItemLegality legalityOf(@Nullable ItemStack itemStack) {
        if (itemStack == null || MaterialUtil.AIR.get().contains(itemStack.getType())) {
            return ItemLegality.LEGAL;
        }
        if (!this.checkStored && MaterialUtil.INVENTORY_HOLDERS.get().contains(itemStack.getType())) {
            return ItemLegality.LEGAL;
        }
        if (ItemUtil.getNBTString(itemStack).contains("run_command")) {
            return ItemLegality.ILLEGAL;
        }
        return ItemLegality.LEGAL;
    }

    @Override
    public void handleItem(ItemStack itemStack, ItemLegality legality) {
        if (legality != ItemLegality.LEGAL) {
            itemStack.setAmount(0);
        }
    }
}

