/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.illegals.items.nbt;

import de.tr7zw.nbtapi.NBT;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import me.xginko.aef.modules.illegals.items.IllegalItemModule;
import me.xginko.aef.utils.ItemUtil;
import me.xginko.aef.utils.MaterialUtil;
import me.xginko.aef.utils.enums.IllegalHandling;
import me.xginko.aef.utils.enums.ItemLegality;
import me.xginko.aef.utils.permissions.AEFPermission;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jetbrains.annotations.NotNull;

public class NBTFilledStorageItem
extends IllegalItemModule {
    private final Set<Material> storageTypes;
    private final String stored_items_tag;
    private final boolean checkStored;

    public NBTFilledStorageItem() {
        super("illegals.nbt.impossibly-stored-items", false, AEFPermission.BYPASS_ILLEGAL_NBT_STOREDITEMS, "Bypass permission: " + AEFPermission.BYPASS_ILLEGAL_NBT_STOREDITEMS.node() + "\nPrevents usage of or deletes storage items that have been pre-filled\nwith items using NBT tags. These can only be created by players with\ncreative access.\nMost commonly dispensers, droppers and chests containing kit shulkers\nare created but there are more combinations possible.");
        this.stored_items_tag = this.config.getString(this.configPath + ".tag", "BlockEntityTag", "The exact name of the nbt tag that signals items are stored inside.");
        this.checkStored = this.config.getBoolean(this.configPath + ".check-stored-items", false);
        this.storageTypes = this.config.getList(this.configPath + ".storage-types", MaterialUtil.INVENTORY_HOLDERS.get().stream().filter(material -> !MaterialUtil.SHULKER_BOXES.get().contains(material)).map(Enum::name).sorted().collect(Collectors.toList())).stream().map(configuredType -> {
            try {
                return Material.valueOf((String)configuredType);
            }
            catch (IllegalArgumentException e) {
                this.notRecognized(Material.class, (String)configuredType);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toCollection(() -> EnumSet.noneOf(Material.class)));
    }

    @Override
    @NotNull
    public ItemLegality legalityOf(@Nullable ItemStack itemStack) {
        if (itemStack == null || MaterialUtil.AIR.get().contains(itemStack.getType())) {
            return ItemLegality.LEGAL;
        }
        if (this.storageTypes.contains(itemStack.getType()) && NBT.readNbt((ItemStack)itemStack).getKeys().contains(this.stored_items_tag)) {
            return ItemLegality.ILLEGAL;
        }
        if (this.checkStored) {
            return this.legalityOf(ItemUtil.getStoredItems(itemStack));
        }
        return ItemLegality.LEGAL;
    }

    @Override
    public void handleItem(ItemStack itemStack, ItemLegality legality) {
        if (this.illegalHandling == IllegalHandling.PREVENT_USE_ONLY) {
            return;
        }
        if (legality != ItemLegality.LEGAL) {
            itemStack.setAmount(0);
        }
    }
}

