/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.lagpreventions;

import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.xginko.aef.libs.xseries.XEntityType;
import me.xginko.aef.libs.xseries.base.XBase;
import me.xginko.aef.modules.AEFModule;
import org.bukkit.entity.EntityType;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntitySpawnEvent;
import org.bukkit.plugin.Plugin;

public class DisableCustomEntities
extends AEFModule
implements Listener {
    private final Set<EntityType> disabledEntities;

    public DisableCustomEntities() {
        super("lag-preventions.disable-entity-spawns", false, "Prevent certain entity types from spawning to combat lag.\nFish types are added by default on newer versions since they\ncan cause a ton of lag.\nNote: This will not remove entities that have already spawned.");
        List<String> defaults = Stream.of(XEntityType.COD, XEntityType.SALMON, XEntityType.PUFFERFISH, XEntityType.TROPICAL_FISH, XEntityType.BAT, XEntityType.PHANTOM).filter(XBase::isSupported).map(XEntityType::get).map(Enum::name).collect(Collectors.toList());
        this.disabledEntities = this.config.getList(this.configPath + ".types", defaults).stream().map(configuredType -> {
            try {
                return EntityType.valueOf((String)configuredType);
            }
            catch (IllegalArgumentException exception) {
                this.notRecognized(EntityType.class, (String)configuredType);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toCollection(() -> EnumSet.noneOf(EntityType.class)));
    }

    @Override
    public void enable() {
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
    }

    @Override
    public void disable() {
        HandlerList.unregisterAll((Listener)this);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void onEntitySpawn(EntitySpawnEvent event) {
        if (this.disabledEntities.contains(event.getEntityType())) {
            event.setCancelled(true);
        }
    }
}

