/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.lagpreventions;

import me.xginko.aef.libs.xseries.XMaterial;
import me.xginko.aef.modules.AEFModule;
import me.xginko.aef.utils.BlockUtil;
import org.bukkit.block.Block;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.plugin.Plugin;

public class FloodingMachines
extends AEFModule
implements Listener {
    private final boolean remove;

    public FloodingMachines() {
        super("lag-preventions.prevent-flooding-machines", false, "Will prevent pistons from pushing waterlogged blocks.");
        this.remove = this.config.getBoolean(this.configPath + ".delete-waterlogged-blocks", true);
    }

    @Override
    public void enable() {
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
    }

    @Override
    public boolean shouldEnable() {
        return this.configEnabled && BlockUtil.isWaterloggedAvailable();
    }

    @Override
    public void disable() {
        HandlerList.unregisterAll((Listener)this);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void onPistonExtend(BlockPistonExtendEvent event) {
        for (Block block : event.getBlocks()) {
            if (!BlockUtil.isWaterlogged(block.getState())) continue;
            if (this.remove) {
                block.setType(XMaterial.AIR.get());
            }
            event.setCancelled(true);
            return;
        }
    }
}

