/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.lagpreventions;

import java.time.Duration;
import java.util.UUID;
import me.xginko.aef.AnarchyExploitFixes;
import me.xginko.aef.libs.caffeine.cache.Cache;
import me.xginko.aef.libs.caffeine.cache.Caffeine;
import me.xginko.aef.libs.xseries.XMaterial;
import me.xginko.aef.modules.AEFModule;
import org.bukkit.Location;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.plugin.Plugin;

public class LeverSpam
extends AEFModule
implements Listener {
    private final long cacheTimeMillis;
    private final int leverUsageLimit;
    private final boolean shouldKickPlayer;
    private final boolean sendActionBar;
    private Cache<Location, Integer> leverLocationCooldowns;
    private Cache<UUID, Integer> playersUsingLeversCooldowns;

    public LeverSpam() {
        super("lag-preventions.prevent-lever-spam", false, "Rate Limit levers to prevent a lag exploit.");
        this.sendActionBar = this.config.getBoolean(this.configPath + ".show-actionbar", true);
        this.shouldKickPlayer = this.config.getBoolean(this.configPath + ".kick-player", false);
        this.leverUsageLimit = this.config.getInt(this.configPath + ".max-lever-usages-per-time", 15);
        this.cacheTimeMillis = (long)this.config.getInt(this.configPath + ".lever-time-in-ticks", 40) * 50L;
    }

    @Override
    public void enable() {
        this.leverLocationCooldowns = Caffeine.newBuilder().expireAfterWrite(Duration.ofMillis(this.cacheTimeMillis)).build();
        this.playersUsingLeversCooldowns = Caffeine.newBuilder().expireAfterWrite(Duration.ofMillis(this.cacheTimeMillis)).build();
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
    }

    @Override
    public void disable() {
        HandlerList.unregisterAll((Listener)this);
        if (this.leverLocationCooldowns != null) {
            this.leverLocationCooldowns.invalidateAll();
            this.leverLocationCooldowns.cleanUp();
            this.leverLocationCooldowns = null;
        }
        if (this.playersUsingLeversCooldowns != null) {
            this.playersUsingLeversCooldowns.invalidateAll();
            this.playersUsingLeversCooldowns.cleanUp();
            this.playersUsingLeversCooldowns = null;
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void onInteract(PlayerInteractEvent event) {
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (event.getClickedBlock().getType() != XMaterial.LEVER.get()) {
            return;
        }
        Location leverLoc = event.getClickedBlock().getLocation();
        Integer activationCount = this.leverLocationCooldowns.getIfPresent(leverLoc);
        if (activationCount == null) {
            activationCount = 0;
        }
        Integer n = activationCount;
        activationCount = activationCount + 1;
        this.leverLocationCooldowns.put(leverLoc, activationCount);
        if (activationCount > this.leverUsageLimit) {
            event.setCancelled(true);
            if (this.shouldKickPlayer) {
                event.getPlayer().kickPlayer(AnarchyExploitFixes.translation((String)event.getPlayer().getLocale()).lagpreventions_stopSpammingLevers);
                return;
            }
            if (this.sendActionBar) {
                event.getPlayer().sendActionBar(AnarchyExploitFixes.translation((String)event.getPlayer().getLocale()).lagpreventions_stopSpammingLevers);
            }
            return;
        }
        Integer leverFlickCount = this.playersUsingLeversCooldowns.getIfPresent(event.getPlayer().getUniqueId());
        if (leverFlickCount == null) {
            leverFlickCount = 0;
        }
        Integer n2 = leverFlickCount;
        leverFlickCount = leverFlickCount + 1;
        this.playersUsingLeversCooldowns.put(event.getPlayer().getUniqueId(), leverFlickCount);
        if (leverFlickCount > this.leverUsageLimit) {
            event.setCancelled(true);
            if (this.shouldKickPlayer) {
                event.getPlayer().kickPlayer(AnarchyExploitFixes.translation((String)event.getPlayer().getLocale()).lagpreventions_stopSpammingLevers);
                return;
            }
            if (this.sendActionBar) {
                event.getPlayer().sendActionBar(AnarchyExploitFixes.translation((String)event.getPlayer().getLocale()).lagpreventions_stopSpammingLevers);
            }
        }
    }
}

