/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.lagpreventions.agelimits;

import java.util.EnumMap;
import java.util.Map;
import java.util.TreeMap;
import me.xginko.aef.libs.configmaster.api.ConfigSection;
import me.xginko.aef.libs.xseries.XEntityType;
import me.xginko.aef.modules.AEFModule;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class CustomAgeLimits
extends AEFModule
implements Runnable,
Listener {
    private final Map<EntityType, Integer> entityLimits = new EnumMap<EntityType, Integer>(EntityType.class);
    private final long checkPeriod;
    private final boolean logIsEnabled = this.config.getBoolean(this.configPath + ".log-removals", false);
    private BukkitTask bukkitTask;

    public CustomAgeLimits() {
        super("lag-preventions.entity-age-limits.custom-limits", false, "Kill certain entities after a custom amount of ticks lived.");
        this.checkPeriod = this.config.getInt(this.configPath + ".check-period-in-ticks", 1200, "Check all loaded chunks every x ticks.");
        EnumMap<XEntityType, Integer> defaults = new EnumMap<XEntityType, Integer>(XEntityType.class);
        defaults.put(XEntityType.ARROW, 120);
        defaults.put(XEntityType.SPECTRAL_ARROW, 120);
        defaults.put(XEntityType.FALLING_BLOCK, 160);
        defaults.put(XEntityType.WITHER_SKULL, 100);
        defaults.put(XEntityType.SNOWBALL, 100);
        TreeMap<String, Object> versionDefaults = new TreeMap<String, Object>();
        for (Map.Entry entry : defaults.entrySet()) {
            if (!((XEntityType)entry.getKey()).isSupported()) continue;
            versionDefaults.put(((XEntityType)entry.getKey()).get().name(), entry.getValue());
        }
        ConfigSection section = this.config.getConfigSection(this.configPath + ".limited-types", versionDefaults, "Check the paper api for correct EntityType enums:\nhttps://jd.papermc.io/paper/1.20/org/bukkit/entity/EntityType.html\nMake sure your minecraft version is matching as well.");
        for (String configuredEntity : section.getKeys(false)) {
            try {
                EntityType limitedEntity = EntityType.valueOf((String)configuredEntity);
                Integer maxAmountPerChunk = Integer.parseInt(section.getString(configuredEntity));
                this.entityLimits.put(limitedEntity, maxAmountPerChunk);
            }
            catch (NumberFormatException e) {
                this.notRecognized(Integer.class, configuredEntity);
            }
            catch (IllegalArgumentException e) {
                this.notRecognized(Material.class, configuredEntity);
            }
        }
    }

    @Override
    public void enable() {
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
        this.bukkitTask = this.plugin.getServer().getScheduler().runTaskTimer((Plugin)this.plugin, (Runnable)this, this.checkPeriod, this.checkPeriod);
    }

    @Override
    public void disable() {
        HandlerList.unregisterAll((Listener)this);
        if (this.bukkitTask != null) {
            this.bukkitTask.cancel();
            this.bukkitTask = null;
        }
    }

    @Override
    public void run() {
        for (World world : this.plugin.getServer().getWorlds()) {
            for (Entity entity : world.getEntities()) {
                if (!this.entityLimits.containsKey(entity.getType()) || entity.getTicksLived() <= this.entityLimits.get(entity.getType())) continue;
                entity.remove();
                if (!this.logIsEnabled) continue;
                this.info("Removed " + entity.getType().name() + " due to old age.");
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void onChunkLoad(ChunkLoadEvent event) {
        if (event.isNewChunk()) {
            return;
        }
        for (Entity entity : event.getChunk().getEntities()) {
            if (!this.entityLimits.containsKey(entity.getType()) || entity.getTicksLived() <= this.entityLimits.get(entity.getType())) continue;
            entity.remove();
            if (!this.logIsEnabled) continue;
            this.info("Removed " + entity.getType().name() + " due to old age.");
        }
    }
}

