/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.lagpreventions.agelimits;

import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.xginko.aef.libs.xseries.XEntityType;
import me.xginko.aef.libs.xseries.base.XBase;
import me.xginko.aef.modules.AEFModule;
import me.xginko.aef.utils.EntityUtil;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class ProjectileAgeLimit
extends AEFModule
implements Runnable,
Listener {
    private final Set<EntityType> ignoredTypes;
    private final long checkPeriod;
    private final int max_alive_time;
    private BukkitTask bukkitTask;

    public ProjectileAgeLimit() {
        super("lag-preventions.entity-age-limits.projectile-limit", false, "Patches any lag exploit that abuses spawning a ton of projectile entities\n(ex. Snowball exploit).Skips over the following entities: ENDER_PEARL, FISHING_HOOK, WITHER_SKULL\nand ENDER_SIGNAL. You can configure those separately in the custom entity age\nlimit section.");
        this.max_alive_time = this.config.getInt(this.configPath + ".max-alive-time-ticks", 300, "(20 ticks = 1 second) Will not touch Ender Pearls");
        this.checkPeriod = (long)this.config.getInt(this.configPath + ".check-period-seconds", 20, "How frequently we should check all projectiles for their alive time") * 20L;
        List<String> defaults = Stream.of(XEntityType.FISHING_BOBBER, XEntityType.ENDER_PEARL, XEntityType.WITHER_SKULL, XEntityType.EYE_OF_ENDER).filter(XBase::isSupported).map(XEntityType::get).map(Enum::name).collect(Collectors.toList());
        this.ignoredTypes = this.config.getList(this.configPath + ".ignored-types", defaults).stream().map(configuredType -> {
            try {
                return EntityType.valueOf((String)configuredType);
            }
            catch (IllegalArgumentException e) {
                this.notRecognized(EntityType.class, (String)configuredType);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toCollection(() -> EnumSet.noneOf(EntityType.class)));
    }

    @Override
    public void enable() {
        this.bukkitTask = this.plugin.getServer().getScheduler().runTaskTimer((Plugin)this.plugin, (Runnable)this, this.checkPeriod, this.checkPeriod);
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
    }

    @Override
    public void disable() {
        HandlerList.unregisterAll((Listener)this);
        if (this.bukkitTask != null) {
            this.bukkitTask.cancel();
            this.bukkitTask = null;
        }
    }

    @Override
    public void run() {
        for (World world : this.plugin.getServer().getWorlds()) {
            for (Entity entity : world.getEntities()) {
                if (this.ignoredTypes.contains(entity.getType()) || !EntityUtil.isProjectile(entity) || entity.getTicksLived() <= this.max_alive_time) continue;
                entity.remove();
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void onChunkLoad(ChunkLoadEvent event) {
        if (event.isNewChunk()) {
            return;
        }
        for (Entity entity : event.getChunk().getEntities()) {
            if (this.ignoredTypes.contains(entity.getType()) || !EntityUtil.isProjectile(entity) || entity.getTicksLived() <= this.max_alive_time) continue;
            entity.remove();
        }
    }
}

