/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.lagpreventions.regionalactivity;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import me.xginko.aef.libs.configmaster.api.ConfigSection;
import me.xginko.aef.libs.xseries.XMaterial;
import me.xginko.aef.modules.lagpreventions.regionalactivity.RegionalActivityModule;
import me.xginko.aef.utils.LocationUtil;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.event.block.BlockEvent;

public abstract class RegionalBlockActivityModule
extends RegionalActivityModule {
    protected final Map<Material, Integer> typedActivityLimit = new EnumMap<Material, Integer>(Material.class);

    public RegionalBlockActivityModule(String subConfigPath, boolean defEnabled, boolean deflogEnabled, int totalLimit, double defCheckRadius, int defPauseMillis, int defCacheMillis, double defPauseTPS, double defPauseMSPT, Map<XMaterial, Integer> defaultTypeSettings) {
        this(subConfigPath, defEnabled, deflogEnabled, totalLimit, defCheckRadius, defPauseMillis, defCacheMillis, defPauseTPS, defPauseMSPT, defaultTypeSettings, null);
    }

    public RegionalBlockActivityModule(String subConfigPath, boolean defEnabled, boolean deflogEnabled, int totalLimit, double defCheckRadius, int defPauseMillis, int defCacheMillis, double defPauseTPS, double defPauseMSPT, Map<XMaterial, Integer> defaultTypeSettings, String comment) {
        super(subConfigPath, defEnabled, deflogEnabled, totalLimit, defCheckRadius, defPauseMillis, defCacheMillis, defPauseTPS, defPauseMSPT, comment);
        HashMap<String, Object> defaultKV = new HashMap<String, Object>(defaultTypeSettings.size());
        for (Map.Entry<XMaterial, Integer> entry : defaultTypeSettings.entrySet()) {
            if (!entry.getKey().isSupported()) continue;
            defaultKV.put(entry.getKey().get().name(), entry.getValue());
        }
        ConfigSection typedSection = this.config.getConfigSection(this.configPath + ".typed-limits", defaultKV, "Set activity limits per Material (BlockType).Note that you cannot set a value higher than the one configured in total-limit.");
        for (String configuredMaterial : typedSection.getKeys(false)) {
            try {
                this.typedActivityLimit.put(Material.valueOf((String)configuredMaterial), Integer.parseInt(typedSection.getString(configuredMaterial)));
            }
            catch (NumberFormatException e) {
                this.notRecognized(Integer.class, typedSection.getString(configuredMaterial));
            }
            catch (IllegalArgumentException e) {
                this.notRecognized(GameMode.class, configuredMaterial);
            }
        }
    }

    protected <T extends BlockEvent> boolean shouldCancelBlockEvent(T blockEvent) {
        return this.shouldCancelEvent(blockEvent, blockEvent.getBlock().getLocation()) || this.shouldCancelBecauseTypeActivity(blockEvent);
    }

    protected <T extends BlockEvent> boolean shouldCancelBecauseTypeActivity(T blockEvent) {
        if (!this.typedActivityLimit.containsKey(blockEvent.getBlock().getType())) {
            return false;
        }
        int typeLimit = this.typedActivityLimit.get(blockEvent.getBlock().getType());
        RegionalActivityModule.RegionData regionData = this.getRegionData(blockEvent.getBlock().getLocation());
        RegionalActivityModule.RegionData.ActivityData activityData = regionData.getBlockActivityData(blockEvent.getBlock().getType());
        if (activityData.resumeTimeMillis.get() > System.currentTimeMillis()) {
            if (this.logIsEnabled) {
                this.info("Cancelling " + blockEvent.getClass().getSimpleName() + " for " + blockEvent.getBlock().getType().name() + " at " + LocationUtil.toString(blockEvent.getBlock().getLocation()) + " because it exceeded its activity (limit: " + typeLimit + ").");
            }
            return true;
        }
        if (activityData.activityCount.incrementAndGet() > typeLimit) {
            if (this.logIsEnabled) {
                this.warn("Disabling " + blockEvent.getBlock().getType().name() + " in a radius of " + this.checkRadius + " blocks from center at x=" + regionData.region.getCenterX() + ", z=" + regionData.region.getCenterZ() + " in world " + blockEvent.getBlock().getWorld().getName() + " for " + this.pauseTimeMillis + "ms, because of too high activity within the configured timeframe: " + activityData.activityCount + " (limit: " + typeLimit + ")");
            }
            activityData.resumeTimeMillis.set(System.currentTimeMillis() + this.pauseTimeMillis);
            activityData.activityCount.set(0);
            return true;
        }
        return false;
    }
}

