/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.lagpreventions.regionalactivity;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import me.xginko.aef.libs.configmaster.api.ConfigSection;
import me.xginko.aef.libs.xseries.XEntityType;
import me.xginko.aef.modules.lagpreventions.regionalactivity.RegionalActivityModule;
import me.xginko.aef.utils.LocationUtil;
import org.bukkit.GameMode;
import org.bukkit.entity.EntityType;
import org.bukkit.event.entity.EntityEvent;

public abstract class RegionalEntityActivityModule
extends RegionalActivityModule {
    protected final Map<EntityType, Integer> typedActivityLimit = new EnumMap<EntityType, Integer>(EntityType.class);

    public RegionalEntityActivityModule(String subConfigPath, boolean defEnabled, boolean deflogEnabled, int totalLimit, double defCheckRadius, int defPauseMillis, int defCacheMillis, double defPauseTPS, double defPauseMSPT, Map<XEntityType, Integer> defaultTypeSettings) {
        this(subConfigPath, defEnabled, deflogEnabled, totalLimit, defCheckRadius, defPauseMillis, defCacheMillis, defPauseTPS, defPauseMSPT, defaultTypeSettings, null);
    }

    public RegionalEntityActivityModule(String subConfigPath, boolean defEnabled, boolean deflogEnabled, int totalLimit, double defCheckRadius, int defPauseMillis, int defCacheMillis, double defPauseTPS, double defPauseMSPT, Map<XEntityType, Integer> defaultTypeSettings, String comment) {
        super(subConfigPath, defEnabled, deflogEnabled, totalLimit, defCheckRadius, defPauseMillis, defCacheMillis, defPauseTPS, defPauseMSPT, comment);
        HashMap<String, Object> defaultKV = new HashMap<String, Object>(defaultTypeSettings.size());
        for (Map.Entry<XEntityType, Integer> entry : defaultTypeSettings.entrySet()) {
            if (!entry.getKey().isSupported()) continue;
            defaultKV.put(entry.getKey().get().name(), entry.getValue());
        }
        ConfigSection typedSection = this.config.getConfigSection(this.configPath + ".typed-limits", defaultKV, "Set activity limits per EntityType.Note that you cannot set a value higher than the one configured in total-limit.");
        for (String configuredEntity : typedSection.getKeys(false)) {
            try {
                this.typedActivityLimit.put(EntityType.valueOf((String)configuredEntity), Integer.parseInt(typedSection.getString(configuredEntity)));
            }
            catch (NumberFormatException e) {
                this.notRecognized(Integer.class, typedSection.getString(configuredEntity));
            }
            catch (IllegalArgumentException e) {
                this.notRecognized(GameMode.class, configuredEntity);
            }
        }
    }

    protected <T extends EntityEvent> boolean shouldCancelEntityEvent(T entityEvent) {
        return this.shouldCancelEvent(entityEvent, entityEvent.getEntity().getLocation()) || this.shouldCancelBecauseTypeActivity(entityEvent);
    }

    protected <T extends EntityEvent> boolean shouldCancelBecauseTypeActivity(T entityEvent) {
        if (!this.typedActivityLimit.containsKey(entityEvent.getEntity().getType())) {
            return false;
        }
        int typeLimit = this.typedActivityLimit.get(entityEvent.getEntityType());
        RegionalActivityModule.RegionData regionData = this.getRegionData(entityEvent.getEntity().getLocation());
        RegionalActivityModule.RegionData.ActivityData activityData = regionData.getEntityActivityData(entityEvent.getEntityType());
        if (activityData.resumeTimeMillis.get() > System.currentTimeMillis()) {
            if (this.logIsEnabled) {
                this.info("Cancelling " + entityEvent.getClass().getSimpleName() + " for " + entityEvent.getEntityType().name() + " at " + LocationUtil.toString(entityEvent.getEntity().getLocation()) + " because it exceeded its activity (limit: " + typeLimit + ").");
            }
            return true;
        }
        if (activityData.activityCount.incrementAndGet() > typeLimit) {
            if (this.logIsEnabled) {
                this.warn("Disabling " + entityEvent.getEntityType().name() + " in a radius of " + this.checkRadius + " blocks from center at x=" + regionData.region.getCenterX() + ", z=" + regionData.region.getCenterZ() + " in world " + entityEvent.getEntity().getWorld().getName() + " for " + this.pauseTimeMillis + "ms, because of too high activity within the configured timeframe: " + activityData.activityCount + " (limit: " + typeLimit + ")");
            }
            activityData.resumeTimeMillis.set(System.currentTimeMillis() + this.pauseTimeMillis);
            activityData.activityCount.set(0);
            return true;
        }
        return false;
    }
}

