/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.misc;

import com.github.retrooper.packetevents.manager.server.ServerVersion;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import me.xginko.aef.AnarchyExploitFixes;
import me.xginko.aef.libs.configmaster.api.ConfigSection;
import me.xginko.aef.libs.xseries.XMaterial;
import me.xginko.aef.modules.AEFModule;
import me.xginko.aef.utils.ChunkUtil;
import me.xginko.aef.utils.enums.Platform;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class BedrockFiller
extends AEFModule
implements Runnable,
Listener {
    private final Map<String, Set<Integer>> worldBedrockLevels;
    private final double pauseTPS;
    private final double pauseMSPT;
    private final long checkPeriodTicks;
    private final boolean fillOnChunkLoad;
    private final boolean fillPeriodically;
    private final boolean pauseOnLag;
    private BukkitTask bukkitTask;

    public BedrockFiller() {
        super("misc.bedrock-filler", false, "Fills holes in bedrock layers.");
        this.fillOnChunkLoad = this.config.getBoolean(this.configPath + ".fill-on-chunkload", false);
        this.fillPeriodically = this.config.getBoolean(this.configPath + ".fill-periodically", true);
        this.checkPeriodTicks = (long)this.config.getInt(this.configPath + ".check-period-seconds", 30) * 20L;
        this.pauseOnLag = this.config.getBoolean(this.configPath + ".pause-on-lag", true);
        this.pauseTPS = this.config.getDouble(this.configPath + ".pause-tps", 16.0);
        this.pauseMSPT = this.config.getDouble(this.configPath + ".pause-mspt", 100.0);
        HashMap<String, Object> defaults = new HashMap<String, Object>(2);
        defaults.put("world", Collections.singletonList(Platform.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_17) ? -64 : 0));
        defaults.put("world_nether", Arrays.asList(127, 0));
        ConfigSection section = this.config.getConfigSection(this.configPath + ".world-levels", defaults);
        List<String> worlds = section.getKeys(false);
        this.worldBedrockLevels = new HashMap<String, Set<Integer>>(worlds.size());
        for (String world : worlds) {
            Set yLevels = section.getList(world).stream().map(configuredYLevel -> {
                if (configuredYLevel instanceof Integer) {
                    return (Integer)configuredYLevel;
                }
                try {
                    if (configuredYLevel instanceof String) {
                        return Integer.parseInt((String)configuredYLevel);
                    }
                    throw new IllegalArgumentException();
                }
                catch (Throwable t2) {
                    this.warn("y-level for world '" + world + "' is not a valid integer.");
                    return null;
                }
            }).filter(Objects::nonNull).collect(Collectors.toSet());
            if (yLevels.isEmpty()) continue;
            this.worldBedrockLevels.put(world, yLevels);
        }
    }

    @Override
    public void enable() {
        if (this.fillOnChunkLoad) {
            this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
        }
        if (this.fillPeriodically) {
            this.bukkitTask = this.plugin.getServer().getScheduler().runTaskTimer((Plugin)this.plugin, (Runnable)this, 1L, this.checkPeriodTicks);
        }
    }

    @Override
    public void disable() {
        HandlerList.unregisterAll((Listener)this);
        if (this.bukkitTask != null) {
            this.bukkitTask.cancel();
            this.bukkitTask = null;
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void onChunkLoad(ChunkLoadEvent event) {
        if (event.isNewChunk() || ChunkUtil.isRetrievalUnsafe(event.getChunk())) {
            return;
        }
        if (!this.worldBedrockLevels.containsKey(event.getWorld().getName())) {
            return;
        }
        if (this.pauseOnLag && this.isServerLagging()) {
            return;
        }
        for (int yLevel : this.worldBedrockLevels.get(event.getWorld().getName())) {
            ChunkUtil.setLayerOf(XMaterial.BEDROCK.get(), yLevel, event.getChunk());
        }
    }

    @Override
    public void run() {
        for (World world : this.plugin.getServer().getWorlds()) {
            if (!this.worldBedrockLevels.containsKey(world.getName())) continue;
            for (Chunk chunk : world.getLoadedChunks()) {
                if (ChunkUtil.isRetrievalUnsafe(chunk) || this.pauseOnLag && this.isServerLagging() || !chunk.isLoaded()) continue;
                for (int yLevel : this.worldBedrockLevels.get(world.getName())) {
                    ChunkUtil.setLayerOf(XMaterial.BEDROCK.get(), yLevel, chunk);
                }
            }
        }
    }

    private boolean isServerLagging() {
        return AnarchyExploitFixes.tickReporter().getGlobalTPS() <= this.pauseTPS || AnarchyExploitFixes.tickReporter().getGlobalMSPT() >= this.pauseMSPT;
    }
}

